<?php
namespace Backend\BaseBundle\Exception;


use Symfony\Component\HttpFoundation\JsonResponse;

class ErrorResponseException extends \Exception
{
    protected $errorMessage;

    public function __construct($message, $code = 0, Exception $previous = null)
    {
        $this->errorMessage = $message;
        parent::__construct('', $code, $previous);
    }
    
    public function makeJsonResponse($status = JsonResponse::HTTP_BAD_REQUEST, $headers = array())
    {
        return new JsonResponse($this->errorMessage, $status, $headers);
    }
}