<?php
namespace Backend\BaseBundle\Controller\API;

use JMS\Serializer\SerializationContext;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpKernel\Exception\HttpException;

abstract class BaseController extends Controller
{

    protected function createHttpException($statusCode, $message = null, \Exception $previous = null, array $headers = array(), $code = 0)
    {
        return new HttpException($statusCode, $message, $previous, $headers, $code);
    }

    protected function createNotFoundJsonResponse($data = '', $headers = array())
    {
        return $this->createJsonResponse($data, Response::HTTP_NOT_FOUND, $headers);
    }

    protected function createJsonResponse($data = '', $status = 200, $headers = array())
    {
        $response = new JsonResponse(array(), $status, $headers);

        if(!is_string($data)){
            $response->setData($data);
        }
        else{
            $response->setContent($data);
        }
        return $response;
    }

    protected function createJsonSerializeResponse($object, array $groups = array())
    {
        $serializer = $this->get('jms_serializer');
        $context = null;
        if($groups){
            $context = SerializationContext::create()->setGroups($groups);
        }
        return $this->createJsonResponse($serializer->serialize($object, 'json', $context));
    }
}