<?php
namespace Backend\BaseBundle\Tests\Event;

use Backend\BaseBundle\Event\Controller\ConfigEvent;
use Backend\BaseBundle\Tests\Fixture\BaseTestCase;

/**
 * @group unit
 */
class ConfigEventTest extends BaseTestCase
{
    public function test___construct()
    {
        //arrange
        $controllerName = 'testControllerName';

        //act
        $configEvent = new ConfigEvent($controllerName);

        //assert
        $this->assertEquals($controllerName, $this->getObjectAttribute($configEvent, 'controllerName'));
    }

    public function test_getControllerName()
    {
        //arrange
        $controllerName = 'testControllerName';
        $configEvent = new ConfigEvent($controllerName);

        //act
        $result = $configEvent->getControllerName();

        //assert
        $this->assertEquals($controllerName, $result);
    }

    public function test_setConfig()
    {
        //arrange
        $configEvent = $this->getMockBuilder(ConfigEvent::class)
            ->disableOriginalConstructor()
            ->setMethods()
            ->getMock();
        $config = 'testConfig';

        //act
        $configEvent->setConfig($config);

        //assert
        $this->assertEquals($config, $this->getObjectAttribute($configEvent, 'config'));
    }

    public function test_getConfig()
    {
        //arrange
        $configEvent = $this->getMockBuilder(ConfigEvent::class)
            ->disableOriginalConstructor()
            ->setMethods()
            ->getMock();
        $config = 'testConfig';
        $configEvent->setConfig($config);

        //act
        $result = $configEvent->getConfig();

        //assert
        $this->assertEquals($config, $result);
    }
}