<?php
namespace Backend\BaseBundle\Service;

use GuzzleHttp\Client;
use JMS\DiExtraBundle\Annotation\Service;

/**
 * @Service("backend_base.custom_g_recaptcha")
 */
class CustomGRecaptchaService
{
    /** @var  Client */
    protected $client;

    public function __construct()
    {
        $this->client = new Client();
    }

    public function captchaVerify($grecaptcha, $secretKey)
    {
        $siteverifyUrl = "https://www.google.com/recaptcha/api/siteverify";
        $queryArray = array(
            "secret" => $secretKey,
            "response" => $grecaptcha
        );

        $response = $this->client->request('GET', $siteverifyUrl, array('query' => $queryArray));
        $data = json_decode($response->getBody(), true);
        
        return $data['success'];
    }
}