$ () ->
    iCheck = () ->
        $('.i-checks').iCheck
            checkboxClass: 'icheckbox_square-green'
            radioClass:    'iradio_square-green'
        return

    syncButton = ($widget) ->
        $container = $widget.find '[data-collection-container]'
        maxCount = parseInt($widget.attr 'data-max-count')
        if maxCount <= $container.find('>[data-collection-item]').length
            $widget.find('[data-prototype-widget]').hide()
            return
        $widget.find('[data-prototype-widget]').show()
        return

    initSingleRequiredCollection = ($widget) ->
        if $widget.find('>label.required').length > 0 && $widget.find('[data-collection-container] >[data-collection-item]').length == 0
            $widget.find('[data-prototype-widget]').trigger 'click'
        if parseInt($widget.attr('data-max-count')) <= 1
            $widget.find('[data-collection-container] >[data-collection-item]:first .select-master').hide()
        return

    syncAllButton = () ->
        $('[data-collection-widget]').each (index, widget) ->
            syncButton $(widget)
            initSingleRequiredCollection $(widget)
            return
        return

    bindEvent = () ->
        $('body').on 'click', '[data-href]', (e) ->
            url = $(@).attr 'data-href'
            window.location = url
            return
        $('body').on 'click', '[data-collection-item] .close-link', (e) ->
            syncAllButton()
            return
        $('body').on 'click', '[data-prototype-widget]', (e) ->
            e.preventDefault()
            $elenemt = $(@)
            $widget = $elenemt.parents('[data-collection-widget]')
            $container = $widget.find '[data-collection-container]'
            maxCount = parseInt($widget.attr 'data-max-count')
            widget = $elenemt.attr 'data-prototype-widget'
            $panel = $ $elenemt.attr 'data-prototype-panel'
            nElements = parseInt $elenemt.attr 'data-prototype-element-count'
            widget = widget.replace(/__name__/g, nElements++);
            $elenemt.attr 'data-prototype-element-count', nElements
            $placeholder = $elenemt.parents('*[data-collection-container]').find('>*:last')
            $panel.find('.panel-body').append widget
            $placeholder.before $panel
            syncButton $widget
            iCheck()
            return
        $('body').on 'shown.bs.modal', '.modal', () ->
            $modal = $(@)
            bindEvent = () ->
                hideBatchButton()
                flashUrl = $('[data-flash-url]').attr 'data-flash-url'
                $.getScript flashUrl
                $form = $modal.find('form')
                url = $form.attr 'action'
                $form.submit (e) ->
                    e.preventDefault();
                    postData = new FormData()
                    $.each $(@).serializeArray(), (index, obj) ->
                        postData.append obj.name, obj.value
                    $.each $(@).find('input[type=file]'), (index, obj) ->
                        $obj = $(obj)
                        return if $obj.attr('name') == ''
                        $.each  obj.files, (i, file) ->
                          postData.append obj.name, file
                    $.ajax
                        url:    url
                        type:   'POST'
                        data:   postData
                        cache:  false
                        contentType: false
                        processData: false
                        success: (html) ->
                            $modal.find('.modal-content').html html
                            bindEvent()
                    return
                $modal.find('[data-href]').click (e) ->
                    e.preventDefault()
                    e.stopPropagation()
                    url = $(@).attr 'data-href'
                    $.get url, (html) ->
                        $modal.find('.modal-content').html html
                        bindEvent()
                        return
                $modal.find('[href]').click (e) ->
                    e.preventDefault()
                    url = $(@).attr 'href'
                    $.get url, (html) ->
                        $modal.find('.modal-content').html html
                        bindEvent()
                        return
            bindEvent()
            return
        $('body').on 'hidden.bs.modal', '.modal', () ->
            $(@).removeData('bs.modal')
            return
        $('body').on 'click', '[data-listAction-all]', () ->
            if $(@).is ':checked'
                $("[data-listAction]").prop "checked", true
            else
                $("[data-listAction]").prop "checked", false
            return
        $('body').on 'click', '[data-batch-action-url]', (e) ->
            url = $(@).attr 'data-batch-action-url'
            $('#batchForm').attr 'action', url
            return if !confirm($(@).attr('data-confirm'))
            #e.stopPropagation()
            $('#batchForm').submit()
            e.preventDefault()
            return

    hideBatchButton = () ->
        if $('[data-batch-button] >ul >li').length == 0
            $('[data-batch-button]').remove()
            $('[data-listAction-all]').parent().remove()
            $('[data-listAction]').parent().remove()

    init = () ->
        $('[data-widget=chosen]').chosen()
        $('[data-toggle="tooltip"]').tooltip()
        return

    redrawTab = () ->
        $('form').each (index, form) ->
            return if $(form).find('>[data-tab]').length == 0
            $(form).find('>[data-tab]:first').before '<div class="tabs-container form-group pane-margin"><ul class="nav nav-tabs"></ul><div class="tab-content"></div></div>'
            $container = $(form).find('>[data-tab]:first').prev()
            $container.find('>.tab-content').append $(form).find('>[data-tab]')
            $container.find('>.tab-content >[data-tab]').each (index, tab) ->
                tabId = $(tab).attr('data-tab')
                tabLabel = $(tab).attr('data-tab-label')
                tabErrors = parseInt($(tab).attr('data-tab-errors'))
                if tabErrors > 0
                    $container.find('>.nav-tabs').append "<li><a href='[data-tab=#{tabId}]' data-toggle='tab'>#{tabLabel} <span class='badge badge-danger'>#{tabErrors}</span></a></li>"
                else
                    $container.find('>.nav-tabs').append "<li><a href='[data-tab=#{tabId}]' data-toggle='tab'>#{tabLabel}</a></li>"
                return
            $container.find('> ul.nav-tabs >li:first').addClass 'active'
            $container.find('>.tab-content >[data-tab]:first').addClass 'active'
            return
        return
    init()
    bindEvent()
    iCheck()
    syncAllButton()
    hideBatchButton()
    redrawTab()
    return
