<?php
namespace Backend\BaseBundle\Form\Type;


use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\RepeatedType;
use Symfony\Component\Form\FormBuilderInterface;

class resetPasswordType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder->add('plain_password', RepeatedType::class, array(
            'type' => 'password',
            'first_options'  => array(
                'label' => 'form.label.edit.site_user.password',
                'required' => false,
                'translation_domain' => 'forms',
            ),
            'second_options' => array(
                'label' => 'form.label.edit.site_user.repeat_password',
                'required' => false,
                'translation_domain' => 'forms',
            ),
            'required' => false,
        ));
        $builder->add('submit', SubmitBackType::class, array(
            'with_back' => false,
            'with_reset' => true,
            'translation_domain' => 'forms',
        ));
    }
}