<?php
namespace Backend\BaseBundle\Form\Type;

use Symfony\Component\Form\AbstractType;
use JMS\DiExtraBundle\Annotation\Service;
use JMS\DiExtraBundle\Annotation\Tag;
use Symfony\Component\Form\FormView;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\SubmitButtonTypeInterface;
use Symfony\Component\Form\Extension\Core\Type as BaseType;

/**
 * @Service
 * @Tag("form.type", attributes = {"alias": "submit_back"})
 */
class SubmitBackType extends AbstractType implements SubmitButtonTypeInterface
{
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'with_back' => true,
            'with_save_back' => false,
            'with_reset' => true,
            'back_route' => '',
        ));
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder->setAttribute('with_back', $options['with_back']);
        $builder->setAttribute('with_save_back', $options['with_save_back']);
        $builder->setAttribute('with_reset', $options['with_reset']);
        $builder->setAttribute('back_route', $options['back_route']);
    }

    public function buildView(FormView $view, FormInterface $form, array $options)
    {
        $view->vars['with_back'] = $form->getConfig()->getAttribute('with_back');
        $view->vars['with_save_back'] = $form->getConfig()->getAttribute('with_save_back');
        $view->vars['with_reset'] = $form->getConfig()->getAttribute('with_reset');
        $view->vars['back_route'] = $form->getConfig()->getAttribute('back_route');
    }

    public function getParent()
    {
        return BaseType\SubmitType::class;
    }

}