<?php
namespace Backend\BaseBundle\Form\Type;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\Extension\Core\Type as BaseType;


class SiteUserProfileType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder->add(
            'FirstName',
            BaseType\TextType::class,
            array(
                'label' => 'form.label.edit.site_user.first_name',
                'required' => true,
            )
        );
        $builder->add(
            'LastName',
            BaseType\TextType::class,
            array(
                'label' => 'form.label.edit.site_user.last_name',
                'required' => true,
            )
        );
        $builder->add(
            'Email',
            BaseType\EmailType::class,
            array(
                'label' => 'form.label.edit.site_user.email',
                'required' => true,
            )
        );
        $builder->add(
            'PlainPassword',
            BaseType\RepeatedType::class,
            array(
                'type' => 'password',
                'first_options'  => array(
                    'label' => 'form.label.edit.site_user.password',
                    'required' => false,
                ),
                'second_options' => array(
                    'label' => 'form.label.edit.site_user.repeat_password',
                    'required' => false,
                ),
                'required' => false,
            )
        );
        $builder->add(
            'submit',
            SubmitBackType::class,
            array(
                'with_back' => false,
                'with_reset' => true,
            )
        );
    }
}