<?php
namespace Backend\BaseBundle\Form\Type;

use Symfony\Component\Form\AbstractType;
use JMS\DiExtraBundle\Annotation\Service;
use JMS\DiExtraBundle\Annotation\Tag;
use Symfony\Component\Form\FormView;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type as BaseType;

/**
 * @Service
 * @Tag("form.type", attributes = {"alias": "datetime_range_type"})
 */
class DateTimeRangeType extends AbstractType
{
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'with_seconds' => true,
        ));
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder->add('greater', BaseType\DateTimeType::class, array(
            'attr' => array(
                'data-datetime-range-picker' => true,
            ),
            'label' => 'form.label.type.datetimerange.greater',
            'date_widget' => 'single_text',
            'time_widget' => 'single_text',
            'with_seconds' => $options['with_seconds'],
            'required' => false,
        ));
        $builder->add('less', BaseType\DateTimeType::class, array(
            'attr' => array(
                'data-datetime-range-picker' => true,
            ),
            'label' => 'form.label.type.datetimerange.less',
            'date_widget' => 'single_text',
            'time_widget' => 'single_text',
            'with_seconds' => $options['with_seconds'],
            'required' => false,
        ));
    }

    public function buildView(FormView $view, FormInterface $form, array $options)
    {
        $view->vars['with_seconds'] = $form->getConfig()->getAttribute('with_seconds');
    }

    public function getName()
    {
        return 'datetime_range';
    }

}