<?php
namespace Backend\BaseBundle\Controller\Backend;

use Backend\BaseBundle\Form\Type\SiteUserProfileType;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Validator\Constraints;
use Backend\BaseBundle\Model;
use Backend\BaseBundle\Event\RoleTypeEvent;
use Backend\BaseBundle\Controller\BaseController;
use Widget\PhotoBundle\File\PhotoUploadFile;

/**
 * 後台帳號管理
 * @Security("has_role_or_superadmin('ROLE_SUPERADMIN')")
 * @Route("/siteuser")
 */
class SiteUserController extends BaseController
{
    protected function postUpdate($user)
    {
        $userManager = $this->get('site_user_manager');
        $userManager->updateUser($user);
    }

    /**
     * @Route("/profile")
     * @Template("BackendBaseBundle:Backend/Base:edit.html.twig")
     */
    public function profileAction(Request $request)
    {
        $user = Model\SiteUserQuery::create()->findPk($this->getUser()->getId());

        $form = $this->createForm(new SiteUserProfileType(), $user, array(
            'translation_domain' => 'forms',
        ));

        $form->handleRequest($request);

        if($form->isValid()){
            $this->get('site_user_manager')->updateUser($form->getData());
            $this->addFlash('success', 'message.data.success.save');
            return $this->redirectToRouteWithSlug('backend_base_backend_siteuser_profile');
        }
        return array(
            'edit_form' => $form->createView(),
        );
    }

    /**
     * @Route("batch/statustrue")
     * @Method({"POST"})
     * @Security("has_role_or_superadmin('ROLE_SUPERADMIN')")
     */
    public function batchStatusTrueAction(Request $request, Model\Site $site)
    {
        if($ids = $request->request->get('ids')) {
            $siteusers = Model\SiteUserQuery::create()->findPks($ids);
            foreach ($siteusers as $siteuser) {
                if ($siteuser->getSiteId() != $site->getId()) {
                    throw $this->createAccessDeniedException();
                }
                $siteuser->setEnabled(true);
                $this->logOperation($siteuser);
            }
            try {
                $siteusers->save();
                $this->addFlash('success', 'message.data.success.status_true');
            } catch (\PropelException $e) {
                $this->addFlash('error', 'message.data.error.status_true');
            }
        }
        return $this->redirectToRouteWithSlug('backend_base_backend_siteuser_index');
    }

    /**
     * @Route("batch/statusfalse")
     * @Method({"POST"})
     * @Security("has_role_or_superadmin('ROLE_SUPERADMIN')")
     */
    public function batchStatusFalseAction(Request $request, Model\Site $site)
    {
        if($ids = $request->request->get('ids')) {
            $siteusers = Model\SiteUserQuery::create()->findPks($ids);
            foreach ($siteusers as $siteuser) {
                if ($siteuser->getSiteId() != $site->getId()) {
                    throw $this->createAccessDeniedException();
                }
                $siteuser->setEnabled(false);
                $this->logOperation($siteuser);
            }
            try {
                $siteusers->save();
                $this->addFlash('success', 'message.data.success.status_false');
            } catch (\PropelException $e) {
                $this->addFlash('error', 'message.data.error.status_false');
            }
        }
        return $this->redirectToRouteWithSlug('backend_base_backend_siteuser_index');
    }

    /**
     * @Route("batch/delete")
     * @Method({"POST"})
     * @Security("has_role_or_superadmin('ROLE_SUPERADMIN')")
     */
    public function batchDeleteAction(Request $request, Model\Site $site)
    {
        if($ids = $request->request->get('ids')) {
            $siteusers = Model\SiteUserQuery::create()->findPks($ids);
            foreach ($siteusers as $siteuser) {
                if ($siteuser->getSiteId() != $site->getId()) {
                    throw $this->createAccessDeniedException();
                }
                $siteuser->delete();
                $this->logOperation($siteuser);
            }
            try {
                $this->addFlash('success', 'message.data.success.delete');
            } catch (\PropelException $e) {
                $this->addFlash('error', 'message.data.error.delete');
            }
        }
        return $this->redirectToRouteWithSlug('backend_base_backend_siteuser_index');
    }
}