<?php
namespace Backend\BaseBundle\Controller\Backend;

use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Validator\Constraints;
use Backend\BaseBundle\Model;
use Backend\BaseBundle\Controller\BaseController;

/**
 * 後台帳號管理
 * @Security("has_role_or_superadmin('ROLE_SUPERADMIN')")
 * @Route("/sitegroup")
 */
class SiteGroupController extends BaseController
{
    /**
     * @Route("batch/delete")
     * @Method({"POST"})
     * @Security("has_role_or_superadmin('ROLE_SUPERADMIN')")
     */
    public function batchDeleteAction(Request $request, Model\Site $site)
    {
        if($ids = $request->request->get('ids')) {
            $sitegroups = Model\SiteGroupQuery::create()->findPks($ids);
            foreach ($sitegroups as $sitegroup) {
                if ($sitegroup->getSiteId() != $site->getId()) {
                    throw $this->createAccessDeniedException();
                }
                $sitegroup->delete();
                $this->logOperation($sitegroup);
            }
            try {
                $this->addFlash('success', 'message.data.success.delete');
            } catch (\PropelException $e) {
                $this->addFlash('error', 'message.data.error.delete');
            }
        }
        return $this->redirectToRouteWithSlug('backend_base_backend_sitegroup_index');
    }
}