<?php
namespace Backend\BaseBundle\Controller\Backend;

use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Validator\Constraints;
use Backend\BaseBundle\Model;
use Backend\BaseBundle\Event\RoleTypeEvent;
use Backend\BaseBundle\Controller\BaseController;

/**
 * 操作紀錄管理
 * @Security("has_role_or_superadmin('ROLE_OPERATIONLOG_READ')")
 * @Route("/log")
 */
class OperationLogController extends BaseController
{
    public function logOperation(\BaseObject $object)
    {
        return;
    }

    /**
     * @Route("batch/delete")
     * @Method({"POST"})
     * @Security("has_role_or_superadmin('ROLE_OPERATIONLOG_DELETE')")
     */
    public function batchDeleteAction(Request $request, Model\Site $site)
    {
        if($ids = $request->request->get('ids')) {
            $operationLogs = Model\OperationLogQuery::create()->findPks($ids);
            foreach ($operationLogs as $operationLog) {
                if ($operationLog->getSiteId() != $site->getId()) {
                    throw $this->createAccessDeniedException();
                }
                $operationLog->delete();
                $this->logOperation($operationLog);
            }
            try {
                $this->addFlash('success', 'message.data.success.delete');
            } catch (\PropelException $e) {
                $this->addFlash('error', 'message.data.error.delete');
            }
        }
        return $this->redirectToRouteWithSlug('backend_base_backend_operationlog_index');
    }
}