<?php
namespace Backend\BaseBundle\Tests\Twig\Extension;

use Backend\BaseBundle\Tests\Fixture\BaseTestCase;
use Backend\BaseBundle\Model;
use Backend\BaseBundle\Twig\Extension\BackendTwigExtension;

/**
 * @group unit
 */
class BackendTwigExtensionTest extends BaseTestCase
{
    public function test_fetchRelation()
    {
        //arrange
        $user = new Model\SiteUser();
        $site = new Model\Site();
        $site->setSlug('test');
        $user->setSite($site);
        $extension = new BackendTwigExtension();

        //act
        $result = $extension->fetchRelation($user, "Site:Slug");

        //assert
        $this->assertEquals('test', $result);
    }

    /**
     * @dataProvider dataProvider_test_isArrayEmptyValue
     */
    public function test_isArrayEmptyValue($result, $array)
    {
        //arrange
        $extenstion = new BackendTwigExtension();

        //act
        $resultForTest = $this->callObjectMethod($extenstion, 'isArrayEmptyValue', $array);

        //assert
        $this->assertEquals($result, $resultForTest);
    }

    public function dataProvider_test_isArrayEmptyValue()
    {
        return array(
            array(
                'result' => false,
                'array' => array(0 , null, 'some value'),
            ),
            array(
                'result' => true,
                'array' => array(),
            ),
            array(
                'result' => true,
                'array' => array(0, null, false),
            ),
        );
    }

    public function test_isEmptyValue_iterator()
    {
        //arrange
        $array = array(0, 1, 2);
        $arrayObject = new \ArrayObject($array);
        $extenstion = $this->getMock(BackendTwigExtension::class, array('isArrayEmptyValue'));
        $extenstion
            ->expects($this->once())
            ->method('isArrayEmptyValue')
            ->willReturnCallback(function($value) use($array){
                $this->assertEquals($array, $value);
                return 'debug';
            });

        //act
        $result = $extenstion->isEmptyValue($arrayObject);

        //assert
        $this->assertEquals('debug', $result);
    }

    public function test_isEmptyValue_array()
    {
        //arrange
        $array = array(0, 1, 2);
        $extenstion = $this->getMock(BackendTwigExtension::class, array('isArrayEmptyValue'));
        $extenstion
            ->expects($this->once())
            ->method('isArrayEmptyValue')
            ->willReturnCallback(function($value) use($array){
                $this->assertEquals($array, $value);
                return 'debug';
            });

        //act
        $result = $extenstion->isEmptyValue($array);

        //assert
        $this->assertEquals('debug', $result);
    }

    public function test_isEmptyValue_value_false()
    {
        //arrange
        $value = 1212;
        $extenstion = $this->getMock(BackendTwigExtension::class, array('isArrayEmptyValue'));
        $extenstion
            ->expects($this->never())
            ->method('isArrayEmptyValue')
            ->willReturnCallback(function($value){
                $this->assertEquals($array, $value);
                return 'debug';
            });

        //act
        $result = $extenstion->isEmptyValue($value);

        //assert
        $this->assertFalse($result);
    }

    public function test_isEmptyValue_value_true_empty()
    {
        //arrange
        $value = '';
        $extenstion = $this->getMock(BackendTwigExtension::class, array('isArrayEmptyValue'));
        $extenstion
            ->expects($this->never())
            ->method('isArrayEmptyValue')
            ->willReturnCallback(function($value){
                $this->assertEquals($array, $value);
                return 'debug';
            });

        //act
        $result = $extenstion->isEmptyValue($value);

        //assert
        $this->assertTrue($result);
    }

    public function test_isEmptyValue_value_false_zero_string()
    {
        //arrange
        $value = '0';
        $extenstion = $this->getMock(BackendTwigExtension::class, array('isArrayEmptyValue'));
        $extenstion
            ->expects($this->never())
            ->method('isArrayEmptyValue')
            ->willReturnCallback(function($value){
                $this->assertEquals($array, $value);
                return 'debug';
            });

        //act
        $result = $extenstion->isEmptyValue($value);

        //assert
        $this->assertFalse($result);
    }

    public function test_isEmptyValue_value_false_zero()
    {
        //arrange
        $value = 0;
        $extenstion = $this->getMock(BackendTwigExtension::class, array('isArrayEmptyValue'));
        $extenstion
            ->expects($this->never())
            ->method('isArrayEmptyValue')
            ->willReturnCallback(function($value){
                $this->assertEquals($array, $value);
                return 'debug';
            });

        //act
        $result = $extenstion->isEmptyValue($value);

        //assert
        $this->assertFalse($result);
    }

    public function test_isEmptyValue_value_true_null()
    {
        //arrange
        $value = null;
        $extenstion = $this->getMock(BackendTwigExtension::class, array('isArrayEmptyValue'));
        $extenstion
            ->expects($this->never())
            ->method('isArrayEmptyValue')
            ->willReturnCallback(function($value){
                $this->assertEquals($array, $value);
                return 'debug';
            });

        //act
        $result = $extenstion->isEmptyValue($value);

        //assert
        $this->assertTrue($result);
    }

    public function test_isEmptyValue_value_true_false()
    {
        //arrange
        $value = false;
        $extenstion = $this->getMock(BackendTwigExtension::class, array('isArrayEmptyValue'));
        $extenstion
            ->expects($this->never())
            ->method('isArrayEmptyValue')
            ->willReturnCallback(function($value){
                $this->assertEquals($array, $value);
                return 'debug';
            });

        //act
        $result = $extenstion->isEmptyValue($value);

        //assert
        $this->assertTrue($result);
    }
}