<?php
namespace Backend\BaseBundle\Tests\Guesser;

use Backend\BaseBundle\Tests\Fixture\BaseTestCase;
use Backend\BaseBundle\Guesser\ControllerNameGuesser;

/**
 * @group unit
 */
class ControllerNameGuesserTest extends BaseTestCase
{
    public function test_getShortName_full_name_bundle()
    {
        //arrange
        $controllerName = '\\dgFactor\\GeneraterBundle\\Controller\TestController';
        $shortName = 'Test';

        //act
        $guesser = new ControllerNameGuesser($controllerName);
        $result = $guesser->getShortName();

        //arrange
        $this->assertEquals($shortName, $result);
    }

    public function test_getShortName_old_full_name_bundle()
    {
        //arrange
        $controllerName = '\\dgFactor\\Bundle\\GeneraterBundle\\Controller\TestController';
        $shortName = 'Test';

        //act
        $guesser = new ControllerNameGuesser($controllerName);
        $result = $guesser->getShortName();

        //arrange
        $this->assertEquals($shortName, $result);
    }

    public function test_getShortName_short_name_bundle()
    {
        //arrange
        $controllerName = '\\dgFactorGeneraterBundle\\Controller\TestController';
        $shortName = 'Test';

        //act
        $guesser = new ControllerNameGuesser($controllerName);
        $result = $guesser->getShortName();

        //arrange
        $this->assertEquals($shortName, $result);
    }

    public function test_getActionRouteName_full_name_bundle()
    {
        //arrange
        $controllerName = '\\dgFactor\\GeneraterBundle\\Controller\TestController';
        $actionName = 'index';
        $routeName = 'dgfactor_generater_test_index';

        //act
        $guesser = new ControllerNameGuesser($controllerName);
        $result = $guesser->getActionRouteName($actionName);

        //arrange
        $this->assertEquals($routeName, $result);
    }

    public function test_getActionRouteName_old_full_name_bundle()
    {
        //arrange
        $controllerName = '\\dgFactor\\Bundle\\GeneraterBundle\\Controller\TestController';
        $actionName = 'index';
        $routeName = 'dgfactor_generater_test_index';

        //act
        $guesser = new ControllerNameGuesser($controllerName);
        $result = $guesser->getActionRouteName($actionName);

        //arrange
        $this->assertEquals($routeName, $result);
    }

    public function test_getActionRouteName_short_name_bundle()
    {
        //arrange
        $controllerName = '\\dgFactorGeneraterBundle\\Controller\TestController';
        $actionName = 'index';
        $routeName = 'dgfactorgenerater_test_index';

        //act
        $guesser = new ControllerNameGuesser($controllerName);
        $result = $guesser->getActionRouteName($actionName);

        //arrange
        $this->assertEquals($routeName, $result);
    }

    public function test_getControllerName_old_full_name_bundle()
    {
        //arrange
        $controllerClass = '\\dgFactor\\Bundle\\GeneraterBundle\\Controller\TestController';
        $controllerName = 'dgFactorGeneraterBundle:Test';

        //act
        $guesser = new ControllerNameGuesser($controllerClass);
        $result = $guesser->getControllerName();

        //arrange
        $this->assertEquals($controllerName, $result);
    }

    public function test_getControllerName_full_name_bundle()
    {
        //arrange
        $controllerClass = '\\dgFactor\\GeneraterBundle\\Controller\TestController';
        $controllerName = 'dgFactorGeneraterBundle:Test';

        //act
        $guesser = new ControllerNameGuesser($controllerClass);
        $result = $guesser->getControllerName();

        //arrange
        $this->assertEquals($controllerName, $result);
    }

    public function test_getControllerName_short_name_bundle()
    {
        //arrange
        $controllerClass = '\\dgFactorGeneraterBundle\\Controller\TestController';
        $controllerName = 'dgFactorGeneraterBundle:Test';

        //act
        $guesser = new ControllerNameGuesser($controllerClass);
        $result = $guesser->getControllerName();

        //arrange
        $this->assertEquals($controllerName, $result);
    }

    public function test_getBundleNamespace_full_name_bundle()
    {
        //arrange
        $controllerClass = '\\dgFactor\\GeneraterBundle\\Controller\TestController';
        $controllerName = 'dgFactor\\GeneraterBundle';

        //act
        $guesser = new ControllerNameGuesser($controllerClass);
        $result = $guesser->getBundleNamespace();

        //arrange
        $this->assertEquals($controllerName, $result);
    }

    public function test_getBundleNamespace_old_full_name_bundle()
    {
        //arrange
        $controllerClass = '\\dgFactor\\Bundle\\GeneraterBundle\\Controller\TestController';
        $controllerName = 'dgFactor\\Bundle\\GeneraterBundle';

        //act
        $guesser = new ControllerNameGuesser($controllerClass);
        $result = $guesser->getBundleNamespace();

        //arrange
        $this->assertEquals($controllerName, $result);
    }

    public function test_getBundleNamespace_short_name_bundle()
    {
        //arrange
        $controllerClass = '\\dgFactorGeneraterBundle\\Controller\TestController';
        $controllerName = 'dgFactorGeneraterBundle';

        //act
        $guesser = new ControllerNameGuesser($controllerClass);
        $result = $guesser->getBundleNamespace();

        //arrange
        $this->assertEquals($controllerName, $result);
    }

}