<?php
namespace Backend\BaseBundle\Tests\EventListener;

use Backend\BaseBundle\EventListener\LoginCheckRequestListener;
use Backend\BaseBundle\Model\SiteUser;
use Backend\BaseBundle\Service\OperationLogger;
use Backend\BaseBundle\Tests\Fixture\BaseTestCase;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Security\Core\Authentication\Token\UsernamePasswordToken;
use Symfony\Component\Security\Http\Event\InteractiveLoginEvent;

class LoginCheckRequestListenerTest extends BaseTestCase
{
    public function test_onInteractiveLoginEvent_not_site_user()
    {
        //arange
        $logger = $this->getMock(OperationLogger::class, array('log'));
        $logger
            ->expects($this->never())
            ->method('log')
            ;
        $listener = new LoginCheckRequestListener();
        $listener->injectOperationLogger($logger);
        $request = new Request();
        $token = new UsernamePasswordToken('bubble', '', 'abc');
        $event = new InteractiveLoginEvent($request, $token);

        //act
        $listener->onInteractiveLoginEvent($event);

        //assert
    }

    public function test_onInteractiveLoginEvent_site_user()
    {
        //arange
        $user = $this->getMock(SiteUser::class, array('save'));
        $logger = $this->getMock(OperationLogger::class, array('log'));
        $logger
            ->expects($this->once())
            ->method('log')
            ->willReturnCallback(function($userForTest) use($user){
                $this->assertTrue($user === $userForTest);
            });

        ;
        $listener = new LoginCheckRequestListener();
        $listener->injectOperationLogger($logger);
        $request = new Request();
        $token = new UsernamePasswordToken($user, '', 'abc');
        $event = new InteractiveLoginEvent($request, $token);

        //act
        $listener->onInteractiveLoginEvent($event);

        //assert
    }

}