<?php
namespace Backend\BaseBundle\Tests\Event;

use Backend\BaseBundle\Event\Controller\ConfigEvent;
use Backend\BaseBundle\Event\Controller\SetupEvent;
use Backend\BaseBundle\Tests\Fixture\BaseTestCase;

/**
 * @group unit
 */
class SetupEventTest extends BaseTestCase
{

    public function test_setConfig()
    {
        //arrange
        $config = 'testConfig';
        $type = 'test';
        $configs = array(
            'debug' => 'debug_config',
        );
        $setupEvent = new SetupEvent();
        $this->setObjectAttribute($setupEvent, 'config', $configs, SetupEvent::class);

        //act
        $setupEvent->setConfig($type, $config);

        //assert
        $configs[$type] = $config;
        $this->assertEquals($configs, $this->getObjectAttribute($setupEvent, 'config'));
    }

    public function test_getConfig()
    {
        //arrange
        $config = 'testConfig';
        $type = 'test';
        $configs = array(
            'debug' => 'debug_config',
        );
        $configs[$type] = $config;
        $setupEvent = new SetupEvent();
        $this->setObjectAttribute($setupEvent, 'config', $configs, SetupEvent::class);

        //act
        $result = $setupEvent->getConfig();

        //assert
        $this->assertEquals($configs, $result);
    }
}