<?php
namespace Backend\BaseBundle\Tests\Event;


use Backend\BaseBundle\Event\Controller\MenuEvent;
use Backend\BaseBundle\Model\SiteUser;
use Backend\BaseBundle\Service\FunctionCheckerServiceDisabled;
use Backend\BaseBundle\Tests\Fixture\BaseTestCase;

/**
 * @group unit
 */
class MenuEventTest extends BaseTestCase
{
    public function test___construct()
    {
        //arrange
        $user = new SiteUser();
        $requestRouteName = 'test_router_name';
        $requestRouteParams = array(
            'params1' => 'params1',
            'params2' => 'params2',
            'params3' => 'params3',
        );

        $functionChecker = $this->getMock(FunctionCheckerServiceDisabled::class);

        //act
        $menuEvent = new MenuEvent($user, $requestRouteName, $requestRouteParams, $functionChecker);

        //assert
        $this->assertEquals($user, $this->getObjectAttribute($menuEvent, 'user'));
        $this->assertEquals($requestRouteName, $this->getObjectAttribute($menuEvent, 'requestRouteName'));
        $this->assertEquals($requestRouteParams, $this->getObjectAttribute($menuEvent, 'requestRouteParams'));
        $this->assertEquals($functionChecker, $this->getObjectAttribute($menuEvent, 'functionChecker'));
    }

    public function test_getRequestRouteName()
    {
        //arrange
        $requestRouteName = 'test_route_name';
        $menuEvent = $this->getMock(MenuEvent::class, null, array(), '', false);
        $this->setObjectAttribute($menuEvent, 'requestRouteName', $requestRouteName);

        //act
        $result = $menuEvent->getRequestRouteName();

        //assert
        $this->assertEquals($requestRouteName, $result);
    }

    public function test_getUser()
    {
        //arrange
        $user = new SiteUser();
        $menuEvent = $this->getMock(MenuEvent::class, null, array(), '', false);
        $this->setObjectAttribute($menuEvent, 'user', $user);

        //act
        $result = $menuEvent->getUser();

        //assert
        $this->assertEquals($user, $result);
    }

    public function test_addMenu_is_enabled()
    {
        //arrange
        $config = 'test_config';
        $controllerName = 'TestBundle:Controller';
        $functionChecker = $this->getMock(FunctionCheckerServiceDisabled::class, array('isBundleEnabled'));
        $functionChecker
            ->expects($this->once())
            ->method('isBundleEnabled')
            ->willReturnCallback(function($bundleName){
                $this->assertEquals('TestBundle', $bundleName);
                return true;
            });
        $menuEvent = $this->getMock(MenuEvent::class, null, array(), '', false);
        $this->setObjectAttribute($menuEvent, 'functionChecker', $functionChecker);

        //act
        $menuEvent->addMenu($controllerName, $config);
        $result = $this->getObjectAttribute($menuEvent, 'menuConfigs');

        //assert
        $this->assertEquals($config, $result[0]);
    }

    public function test_addMenu_is_not_enabled()
    {
        //arrange
        $config = 'test_config';
        $controllerName = 'TestBundle:Controller';
        $functionChecker = $this->getMock(FunctionCheckerServiceDisabled::class, array('isBundleEnabled'));
        $functionChecker
            ->expects($this->once())
            ->method('isBundleEnabled')
            ->willReturnCallback(function($bundleName){
                $this->assertEquals('TestBundle', $bundleName);
                return false;
            });
        $menuEvent = $this->getMock(MenuEvent::class, null, array(), '', false);
        $this->setObjectAttribute($menuEvent, 'functionChecker', $functionChecker);

        //act
        $menuEvent->addMenu($controllerName, $config);
        $result = $this->getObjectAttribute($menuEvent, 'menuConfigs');

        //assert
        $this->assertEmpty($result);
    }

    /**
     * @dataProvider dataProvider_test_getMenuConfigs
     */
    public function test_getMenuConfigs($resultConfigs, $configs)
    {
        //arrange
        $menuEvent = $this->getMock(MenuEvent::class, null, array(), '', false);
        $this->setObjectAttribute($menuEvent, 'menuConfigs', $configs);

        //act
        $result = $menuEvent->getMenuConfigs();

        //assert
        $this->assertEquals($resultConfigs, $result);
    }

    public function dataProvider_test_getMenuConfigs()
    {
        return array(
            array(
                'resultConfigs' => array(
                    'item1' => array(
                        'class' => 'fa fa-user',
                        'active' => false,
                        'target' => array(
                            'sub.item1' => array(
                                'class' => 'fa fa-sign-in',
                                'active' => false,
                                'target' => 'target1',
                            ),
                        ),
                    ),
                    'item2' => array(
                        'class' => 'fa fa-user',
                        'active' => true,
                        'target' => array(
                            'sub.item2' => array(
                                'class' => 'fa fa-sign-in',
                                'active' => false,
                                'target' => 'target2',
                            ),
                            'sub.item3' => array(
                                'class' => 'fa fa-sign-in',
                                'active' => true,
                                'target' => 'target3',
                            ),
                        ),
                    ),
                ),
                'configs' => array(
                    'BackendBaseBundle' => array(
                        'item1' => array(
                            'class' => 'fa fa-user',
                            'active' => false,
                            'target' => array(
                                'sub.item1' => array(
                                    'class' => 'fa fa-sign-in',
                                    'active' => false,
                                    'target' => 'target1',
                                ),
                            ),
                        ),
                    ),
                    'WidgetPhotoBundle' => array(
                        'item2' => array(
                            'class' => 'fa fa-user',
                            'active' => false,
                            'target' => array(
                                'sub.item2' => array(
                                    'class' => 'fa fa-sign-in',
                                    'active' => false,
                                    'target' => 'target2',
                                ),
                            ),
                        ),
                    ),
                    'WidgetTestBundle' => array(
                        'item2' => array(
                            'class' => 'fa fa-user',
                            'active' => true,
                            'target' => array(
                                'sub.item3' => array(
                                    'class' => 'fa fa-sign-in',
                                    'active' => true,
                                    'target' => 'target3',
                                ),
                            ),
                        ),
                    ),
                ),
            ),
            array(
                'resultConfigs' => array(
                    'item1' => array(
                        'class' => 'fa fa-user',
                        'active' => false,
                        'target' => array(
                            'sub.item1' => array(
                                'class' => 'fa fa-sign-in',
                                'active' => false,
                                'target' => 'target1',
                            ),
                        ),
                    ),
                    'item2' => array(
                        'class' => 'fa fa-user',
                        'active' => false,
                        'target' => array(
                            'sub.item2' => array(
                                'class' => 'fa fa-sign-in',
                                'active' => false,
                                'target' => 'target2',
                            ),
                            'sub.item3' => array(
                                'class' => 'fa fa-sign-in',
                                'active' => false,
                                'target' => 'target3',
                            ),
                        ),
                    ),
                ),
                'configs' => array(
                    'BackendBaseBundle' => array(
                        'item1' => array(
                            'class' => 'fa fa-user',
                            'active' => false,
                            'target' => array(
                                'sub.item1' => array(
                                    'class' => 'fa fa-sign-in',
                                    'active' => false,
                                    'target' => 'target1',
                                ),
                            ),
                        ),
                    ),
                    'WidgetPhotoBundle' => array(
                        'item2' => array(
                            'class' => 'fa fa-user',
                            'active' => false,
                            'target' => array(
                                'sub.item2' => array(
                                    'class' => 'fa fa-sign-in',
                                    'active' => false,
                                    'target' => 'target2',
                                ),
                            ),
                        ),
                    ),
                    'WidgetTestBundle' => array(
                        'item2' => array(
                            'class' => 'fa fa-user',
                            'active' => false,
                            'target' => array(
                                'sub.item3' => array(
                                    'class' => 'fa fa-sign-in',
                                    'active' => false,
                                    'target' => 'target3',
                                ),
                            ),
                        ),
                    ),
                ),
            ),
        );
    }
}