<?php
namespace Backend\BaseBundle\Tests\Controller\Backend;

use Backend\BaseBundle\Model\OperationLog;
use Backend\BaseBundle\Model\OperationLogQuery;
use Backend\BaseBundle\Model\SiteUserQuery;
use Backend\BaseBundle\Tests\Fixture\BackendWebTestCase;

class OperationLogControllerTest extends BackendWebTestCase
{
    /**
     * 沒有權限不應該看到 menu
     */
    public function test_no_rights_should_not_see_menu_entry()
    {
        //arrange
        $slug = 'dgfactor';
        $user = SiteUserQuery::create()->findOneByLoginName('admin');
        $this->loginWithRoles($user);

        //act
        $crawler = $this->client->request('GET', $this->generateUrl('backend_base_backend_default_index', array('slug' => $slug)));
        $response = $this->client->getResponse();

        //assert
        $this->assertTrue($response->isOk());
        $this->assertEquals(0, $crawler->filter("#side-menu li a:contains('操作紀錄')")->count());
    }

    public function test_no_rights_should_not_enter_index()
    {
        //arrange
        $slug = 'dgfactor';
        $user = SiteUserQuery::create()->findOneByLoginName('admin');
        $this->loginWithRoles($user);

        //act
        $crawler = $this->client->request('GET', $this->generateUrl('backend_base_backend_operationlog_index', array('slug' => $slug)));
        $response = $this->client->getResponse();

        //assert
        $this->assertFalse($response->isOk());
    }

    public function test_has_rights_should_see_menu_entry()
    {
        //arrange
        $slug = 'dgfactor';
        $user = SiteUserQuery::create()->findOneByLoginName('admin');
        $roles = array('ROLE_OPERATIONLOG_READ');
        $this->loginWithRoles($user, $roles);

        //act
        $crawler = $this->client->request('GET', $this->generateUrl('backend_base_backend_default_index', array('slug' => $slug)));
        $response = $this->client->getResponse();

        //assert
        $this->assertTrue($response->isOk());
        $this->assertGreaterThanOrEqual(1, $crawler->filter("#side-menu li a:contains('操作紀錄')")->count());
    }

    public function test_has_rights_can_enter_index()
    {
        //arrange
        $slug = 'dgfactor';
        $user = SiteUserQuery::create()->findOneByLoginName('admin');
        $roles = array('ROLE_OPERATIONLOG_READ');
        $this->loginWithRoles($user, $roles);

        //act
        $crawler = $this->client->request('GET', $this->generateUrl('backend_base_backend_operationlog_index', array('slug' => $slug)));
        $response = $this->client->getResponse();

        //assert
        $this->assertTrue($response->isOk());
    }

    public function test_no_rights_should_not_enter_delete()
    {
        //arrange
        $slug = 'dgfactor';
        $user = SiteUserQuery::create()->findOneByLoginName('admin');
        $operationLog = OperationLogQuery::create()->findOne();
        $roles = array('ROLE_OPERATIONLOG_READ');
        $tokenManager = $this->client->getContainer()->get('security.csrf.token_manager');
        $token = $tokenManager->getToken('delete', $roles);
        $this->loginWithRoles($user);

        //act
        $crawler = $this->client->request('GET', $url = $this->generateUrl('backend_base_backend_operationlog_delete', array('slug' => $slug, 'id' => $operationLog->getId())).'?_token='.urlencode($token));
        $response = $this->client->getResponse();

        //assert
        $this->assertFalse($response->isOk());
    }

    public function test_no_rights_should_enter_delete()
    {
        //arrange
        $slug = 'dgfactor';
        $user = SiteUserQuery::create()->findOneByLoginName('admin');
        $operationLog = OperationLogQuery::create()->findOne();
        $operationLogArray = $operationLog->toArray();
        unset($operationLogArray['Id']);
        $operationLog = new OperationLog();
        $operationLog->fromArray($operationLogArray);
        $operationLog->save();

        $roles = array('ROLE_OPERATIONLOG_READ', 'ROLE_OPERATIONLOG_WRITE');
        $tokenManager = $this->client->getContainer()->get('security.csrf.token_manager');
        $token = $tokenManager->getToken('delete', $roles);
        $this->loginWithRoles($user, $roles);

        //act
        $crawler = $this->client->request('GET', $url = $this->generateUrl('backend_base_backend_operationlog_delete', array('slug' => $slug, 'id' => $operationLog->getId())).'?_token='.urlencode($token));
        $response = $this->client->getResponse();

        //assert
        $this->assertTrue($response->isRedirect($this->generateUrl('backend_base_backend_operationlog_index', array('slug' => $slug))));
    }

}