<?php
namespace Backend\BaseBundle\SiteConfig;

use Backend\BaseBundle\Model;

class ModelConfig implements SiteConfigInterface
{

    protected $siteId;

    public function __construct($siteId)
    {
        $this->siteId = $siteId;
    }

    /**
     * @return Model\SiteConfig
     */
    protected function findSiteConfig($name)
    {
        if(!($siteConfig = Model\SiteConfigQuery::create()->findPk(array($this->siteId, $name)))){
            $siteConfig = new Model\SiteConfig();
            $siteConfig->setSiteId($this->siteId);
            $siteConfig->setName($name);
        }
        return $siteConfig;
    }

    public function set($name, $config)
    {
        $siteConfig = $this->findSiteConfig($name);
        $siteConfig->setConfig($config);
        $siteConfig->save();
    }

    public function get($name)
    {
        $siteConfig = $this->findSiteConfig($name);
        return $siteConfig->getConfig($name);
    }

    public function delete($name)
    {
        $siteConfig = $this->findSiteConfig($name);
        if($siteConfig->isNew()){
            return;
        }
        $siteConfig->delete();
    }
}