<?php
namespace Backend\BaseBundle\Guesser;


class ControllerNameGuesser
{
    protected $controllerClass;

    public function __construct($controllerClass)
    {
        $this->controllerClass = $controllerClass;
    }

    public function getShortName()
    {
        preg_match('/.*\\\\(\w*)Controller$/', $this->controllerClass, $match);
        return $match[1];
    }

    public function getActionRouteName($action)
    {
        preg_match('/\\\\?(.*)\\\\Controller\\\\(\w*)\\\\?(\w*)Controller$/', $this->controllerClass, $match);
        $controllerName = $match[3]==''?$match[2]:"{$match[2]}_{$match[3]}";
        $routeName = strtolower("{$match[1]}_{$controllerName}_$action");
        $routeName = str_replace('\\bundle\\', '_', $routeName);
        $routeName = str_replace('bundle', '', $routeName);
        $routeName = str_replace('\\', '_', $routeName);
        return $routeName;
    }

    public function getControllerName()
    {
        preg_match('/\\\\?(.*)\\\\Controller\\\\(\w*)\\\\?(\w*)Controller$/', $this->controllerClass, $match);
        $controllerName = $match[3]==''?$match[2]:"{$match[2]}/{$match[3]}";
        return str_replace(array('\\Bundle\\', '\\'), '', "{$match[1]}:$controllerName");
    }

    public function getBundleNamespace()
    {
        if(!preg_match('/\\\\?(.*)\\\\Controller\\\\(\w*)\\\\?(\w*)Controller$/', $this->controllerClass, $match)){
            return null;
        }
        return $match[1];
    }

    public function getBundleName()
    {
        return str_replace(array('\\Bundle\\', '\\'), '', $this->getBundleNamespace());
    }
}