<?php
namespace Backend\BaseBundle\EventListener\ControllerConfig;

use Backend\BaseBundle\Form\Type\DatepickerType;
use Backend\BaseBundle\Form\Type\SubmitBackType;
use JMS\DiExtraBundle\Annotation\Service;
use JMS\DiExtraBundle\Annotation\Tag;
use JMS\DiExtraBundle\Annotation\Inject;
use JMS\DiExtraBundle\Annotation\InjectParams;
use Backend\BaseBundle\Event\Controller;
use Symfony\Component\EventDispatcher\EventDispatcherInterface;
use Backend\BaseBundle\Model;
use Symfony\Component\Routing\Router;
use Symfony\Component\Form\Extension\Core\Type as BaseType;
use Symfony\Component\Validator\Constraints;


/**
 * @Service
 * @Tag("kernel.event_listener", attributes = {"public": false, "event": Controller\ConfigEvent::EVENT_CONFIG, "method": "onConfig"})
 * @Tag("kernel.event_listener", attributes = {"public": false, "event": Controller\TypeRolesEvent::EVENT_TYPE_ROLES, "method": "onTypeRoles"})
 * @Tag("kernel.event_listener", attributes = {"public": false, "event": Controller\MenuEvent::EVENT_MENU, "method": "onMenu"})
 * @Tag("kernel.event_listener", attributes = {"public": false, "event": Controller\SetupEvent::EVENT_SETUP, "method": "onSystemSetup"})
 * @Tag("kernel.event_listener", attributes = {"public": false, "event": Controller\SetupEvent::EVENT_SETUP, "method": "onMailSetup"})
 */
class SetupListener
{
    const CONTROLLER_NAME = 'BackendBaseBundle:Backend/Setup';

    /** @var  Router */
    protected $router;

    /**
     * @InjectParams()
     */
    public function injectRouter(Router $router)
    {
        $this->router = $router;
    }

    public function onMenu(Controller\MenuEvent $event)
    {
        $isActive = preg_match('/^backend_base_backend_setup_/i', $event->getRequestRouteName());
        $user = $event->getUser();
        if(!$user->hasRoleOrSuperAdmin('ROLE_SETUP')) {
            return;
        }
        $slug = $user->getSiteSlug();
        $event->addMenu(self::CONTROLLER_NAME, array(
            'menu.setup' => array(
                'class' => 'fa fa-cogs',
                'active' => $isActive,
                'target' => array(
                    'menu.setup' => array(
                        'class' => 'fa fa-cog',
                        'active' => $isActive,
                        'target' => $this->router->generate('backend_base_backend_setup_setup', array('slug' => $slug)),
                    ),
                ),
            ),
        ));
    }

    public function onTypeRoles(Controller\TypeRolesEvent $event)
    {
        $event->addTypeRoles('ROLE_SETUP', array(
            'ROLE_SETUP',
        ));
    }

    public function onConfig(Controller\ConfigEvent $event)
    {
        if($event->getControllerName() != self::CONTROLLER_NAME){
            return;
        }

        $event->setConfig(array(
            'route' => array(
                'setup' => true,
            ),
            'security' => array(
                'setup' => 'ROLE_SETUP',
            ),
        ));
    }

    public function onSystemSetup(Controller\SetupEvent $event)
    {
        $event->setConfig('system', array(
            'form' => array(
                array(
                    'recaptcha_site_key',
                    BaseType\TextType::class,
                    array(
                        'label' => 'form.label.setup.system.recaptcha_site_key',
                        'required' => false,
                    ),
                ),
                array(
                    'recaptcha_secret_key',
                    BaseType\TextType::class,
                    array(
                        'label' => 'form.label.setup.system.recaptcha_secret_key',
                        'required' => false,
                    ),
                ),
                array(
                    'domains',
                    BaseType\TextType::class,
                    array(
                        'label' => 'form.label.setup.system.allow_domains',
                        'required' => false,
                    ),
                ),
                array(
                    'submit',
                    SubmitBackType::class,
                    array(
                        'with_back' => false,
                        'with_reset' => true,
                    ),
                ),
            ),
        ));
    }
    public function onMailSetup(Controller\SetupEvent $event)
    {
        $event->setConfig('mail', array(
            'form' => array(
                array(
                    'host',
                    BaseType\TextType::class,
                    array(
                        'label' => 'form.label.setup.mail.smtp_host',
                        'required' => true,
                        'constraints' =>array(
                            new Constraints\NotBlank(),
                        ),
                    ),
                ),
                array(
                    'auth_type',
                    BaseType\ChoiceType::class,
                    array(
                        'label' => 'form.label.setup.mail.smtp_auth_type',
                        'required' => false,
                        'choices' => array(
                            'login' => 'login',
                            'plain' => 'plain',
                        ),
                        'expanded' => false,
                        'multiple' => false,
                    ),
                ),
                array(
                    'encrypt',
                    BaseType\ChoiceType::class,
                    array(
                        'label' => 'form.label.setup.mail.smtp_encrypt',
                        'required' => false,
                        'choices' => array(
                            'tls' => 'tls',
                            'ssl' => 'ssl',
                        ),
                        'expanded' => false,
                        'multiple' => false,
                    ),
                ),
                array(
                    'post',
                    BaseType\TextType::class,
                    array(
                        'label' => 'form.label.setup.mail.smtp_port',
                        'required' => true,
                        'constraints' => array(
                            new Constraints\NotBlank(),
                        ),
                    ),
                ),
                array(
                    'account',
                    BaseType\TextType::class,
                    array(
                        'label' => 'form.label.setup.mail.smtp_account',
                        'required' => false,
                    ),
                ),
                array(
                    'password',
                    BaseType\TextType::class,
                    array(
                        'label' => 'form.label.setup.mail.smtp_password',
                        'required' => false,
                    ),
                ),
                array(
                    'sender_name',
                    BaseType\TextType::class,
                    array(
                        'label' => 'form.label.setup.mail.sender_name',
                    ),
                ),
                array(
                    'sender_mail',
                    BaseType\TextType::class,
                    array(
                        'label' => 'form.label.setup.mail.sender_mail',
                    ),
                ),

                array(
                    'reply_name',
                    BaseType\TextType::class,
                    array(
                        'label' => 'form.label.setup.mail.reply_name',
                        'required' => false,
                    ),
                ),
                array(
                    'reply_mail',
                    BaseType\TextType::class,
                    array(
                        'label' => 'form.label.setup.mail.reply_mail',
                        'required' => false,
                    ),
                ),
                array(
                    'submit',
                    SubmitBackType::class,
                    array(
                        'with_back' => false,
                        'with_reset' => true,
                    ),
                ),
            ),
        ));
    }
}