<?php
namespace Backend\BaseBundle\EventListener\ControllerConfig;

use Backend\BaseBundle\Form\Type\DateTimeRangeType;
use Backend\BaseBundle\Form\Type\RelationType;
use Backend\BaseBundle\Form\Type\SubmitBackType;
use JMS\DiExtraBundle\Annotation\Service;
use JMS\DiExtraBundle\Annotation\Tag;
use JMS\DiExtraBundle\Annotation\Inject;
use JMS\DiExtraBundle\Annotation\InjectParams;
use Backend\BaseBundle\Event\Controller;
use Symfony\Component\EventDispatcher\EventDispatcherInterface;
use Backend\BaseBundle\Model;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\Routing\Router;
use Symfony\Component\Form\Extension\Core\Type as BaseType;
use Widget\PhotoBundle\Form\Type\PhotoUploadType;

/**
 * @Service
 * @Tag("kernel.event_listener", attributes = {"public": false, "event": Controller\ConfigEvent::EVENT_CONFIG, "method": "onConfig"})
 * @Tag("kernel.event_listener", attributes = {"public": false, "event": Controller\TypeRolesEvent::EVENT_TYPE_ROLES, "method": "onTypeRoles"})
 * @Tag("kernel.event_listener", attributes = {"public": false, "event": Controller\MenuEvent::EVENT_MENU, "method": "onMenu"})
 */
class OperationLogListener
{
    const CONTROLLER_NAME = 'BackendBaseBundle:Backend/OperationLog';

    /** @var  EventDispatcherInterface */
    protected $eventDispatcher;

    /** @var  Router */
    protected $router;

    /**
     * @InjectParams()
     */
    public function __construct(EventDispatcherInterface $eventDispatcher, Router $router)
    {
        $this->eventDispatcher = $eventDispatcher;
        $this->router = $router;
    }

    public function onMenu(Controller\MenuEvent $event)
    {
        $isActive = preg_match('/^backend_base_backend_operationlog_/i', $event->getRequestRouteName());
        $user = $event->getUser();
        if(!$user->hasRoleOrSuperAdmin('ROLE_OPERATIONLOG_READ')){
            return;
        }
        $slug = $user->getSiteSlug();
        $event->addMenu(self::CONTROLLER_NAME, array(
            'menu.setup' => array(
                'class' => 'fa fa-user',
                'active' => $isActive,
                'target' => array(
                    'menu.operation_log' => array(
                        'class' => 'fa fa-sign-in',
                        'active' => $isActive,
                        'target' => $this->router->generate('backend_base_backend_operationlog_index', array('slug' => $slug)),
                    ),
                ),
            ),
        ));
    }

    public function onTypeRoles(Controller\TypeRolesEvent $event)
    {
        $event->addTypeRoles('ROLE_OPERATIONLOG', array(
            'ROLE_OPERATIONLOG_READ',
            'ROLE_OPERATIONLOG_WRITE',
        ));
    }

    public function onConfig(Controller\ConfigEvent $event)
    {
        if($event->getControllerName() != self::CONTROLLER_NAME){
            return;
        }
        $event->stopPropagation();

        $roleTypeEvent = new Controller\TypeRolesEvent();
        $this->eventDispatcher->dispatch($roleTypeEvent::EVENT_TYPE_ROLES, $roleTypeEvent);
        $event->setConfig(array(
            'route' => array(
                'sort' => true,
                'index' => true,
                'delete' => true,
                'view' => true,
                'search' => true,
            ),
            'search' => array(
                array(
                    'SiteUser:LoginName',
                    BaseType\TextType::class,
                    array(
                        'label' => 'search.operation_log.login_name',
                        'required' => false,
                    ),
                ),
                array(
                    'CreatedAt',
                    DateTimeRangeType::class,
                    array(
                        'label' => 'search.operation_log.created_at',
                        'required' => false,
                        'with_seconds' => true,
                    ),
                ),
            ),
            'batch' => array(
                'batch.operation_log.delete' => array(
                    'url' => 'backend_base_backend_operationlog_batchdelete',
                    'security' => 'ROLE_OPERATIONLOG_WRITE',
                ),
            ),
            'index' => array(
                '＃' => 'Id',
                'index.operation_log.login_name' =>   'SiteUser:LoginName',
                'index.operation_log.modify_type' =>  '@ModifyType', //@表示需要翻譯欄位內容
                'index.operation_log.modify_table' => '@ModifyTable',
                'index.operation_log.created_at' =>   'CreatedAt',
            ),
            'security' => array(
                'view' => 'ROLE_OPERATIONLOG_READ',
                'delete' => 'ROLE_OPERATIONLOG_WRITE',
            ),
            'action' => array(
                'action.view' => array(
                    'class' => 'fa fa-eye',
                    'action' => 'view',
                    'type' => 'ajax',
                ),
                'action.delete' => array(
                    'class' => 'fa fa-trash',
                    'action' => 'delete',
                    'confirm' => 'message.confirm.delete',
                ),
            ),
            'view' => array(
                'Id' => array(
                    'label' => 'form.label.view.operation_log.id',
                ),
                'SiteUser:LoginName' => array(
                    'label' => 'form.label.view.operation_log.login_name',
                ),
                '@ModifyType' => array(
                    'label' => 'form.label.view.operation_log.modify_type',
                ),
                '@ModifyTable' => array(
                    'label' => 'form.label.view.operation_log.modify_table',
                ),
                'ModifyColumn' => array(
                    'label' => 'form.label.view.operation_log.modify_column',
                ),
                'CreatedAt' => array(
                    'label' => 'form.label.view.operation_log.created_at',
                ),
            ),
        ));
    }
}