<?php
namespace Backend\BaseBundle\Event\Controller;

use Backend\BaseBundle\Model\Site;
use Symfony\Component\EventDispatcher\Event;

class SetupEvent extends Event
{
    const EVENT_SETUP = 'event.controller.setup';

    /** @var  Site */
    protected $site;
    private $config = array();

    public function setSite(Site $site)
    {
        $this->site = $site;
    }

    /**
     * @return Site
     */
    public function getSite()
    {
        return $this->site;
    }

    public function setConfig($type, $config)
    {
        $this->config[$type] = $config;
    }

    public function getConfig()
    {
        return $this->config;
    }

}
