<?php
namespace Backend\BaseBundle\Controller\Backend;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Backend\BaseBundle\Event\Controller\MenuEvent;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;

class CommonController extends Controller
{
    /**
     * @Template()
     */
    public function _sideBarAction()
    {
        $dispatcher = $this->get('event_dispatcher');
        $functionChecker = $this->get('site.function.checker');
        $attributes = $this->get('request_stack')->getMasterRequest()->attributes;
        $event = new MenuEvent($this->getUser(), $attributes->get('_route'), $attributes->get('_route_params'),$functionChecker);
        $dispatcher->dispatch(MenuEvent::EVENT_MENU, $event);
        $menuConfig = $event->getMenuConfigs();
        return array('menuConfig' => $menuConfig);
    }
}