<?php

namespace Backend\BaseBundle\Tests\Service;

use Backend\BaseBundle\Service\LocaleObject;
use Backend\BaseBundle\Service\LocaleSelector;
use Backend\BaseBundle\Tests\Fixture\BaseKernelTestCase;

class LocaleSelectorTest extends BaseKernelTestCase
{
    public function test_inject()
    {
        //arrange

        //act
        $service = $this->container->get("locale_selector");

        //assert
        $this->assertInstanceOf(LocaleObject::class, $this->getObjectAttribute($service, 'localeRead'));
    }

    public function test_findLocale()
    {
        //arrange
        $originLocale = "zh";
        $service = new LocaleSelector();
        $locale = $this->getMockBuilder(LocaleObject::class)
            ->setMethods(array("getEnables"))
            ->getMock();

        $locale->expects($this->once())
            ->method("getEnables")
            ->willReturn(array("zh", 'en'));

        $this->setObjectAttribute($service, "localeRead", $locale);

        //act
        $result = $service->findLocale($originLocale);

        //assert
        $this->assertEquals($originLocale, $result);
    }

    public function test_findLocale_沒帶參數()
    {
        //arrange
        $defaultLocale = "zh";
        $service = new LocaleSelector();
        $locale = $this->getMockBuilder(LocaleObject::class)
            ->setMethods(array("getDefault"))
            ->getMock();

        $locale->expects($this->once())
            ->method("getDefault")
            ->willReturn($defaultLocale);

        $this->setObjectAttribute($service, "localeRead", $locale);

        //act
        $result = $service->findLocale();

        //assert
        $this->assertEquals($defaultLocale, $result);
    }

    public function test_findLocale_localeObject給的enables可能是null()
    {
        //arrange
        $originLocale = "zh";
        $defaultLocale = "jp";
        $service = new LocaleSelector();

        $locale = $this->getMockBuilder(LocaleObject::class)
            ->setMethods(array("getDefault", "getEnables"))
            ->getMock();

        $locale->expects($this->once())
            ->method("getEnables")
            ->willReturn(null);

        $locale->expects($this->once())
            ->method("getDefault")
            ->willReturn($defaultLocale);

        $this->setObjectAttribute($service, "localeRead", $locale);

        //act
        $result = $service->findLocale($originLocale);

        //assert
        $this->assertEquals($defaultLocale, $result);
    }

    public function test_findLocale_參數不在enables中()
    {
        //arrange
        $originLocale = "zh";
        $defaultLocale = "en";
        $service = new LocaleSelector();
        $locale = $this->getMockBuilder(LocaleObject::class)
            ->setMethods(array("getDefault", "getEnables"))
            ->getMock();

        $locale->expects($this->once())
            ->method("getEnables")
            ->willReturn(array("jp", 'en'));

        $locale->expects($this->once())
            ->method("getDefault")
            ->willReturn($defaultLocale);

        $this->setObjectAttribute($service, "localeRead", $locale);

        //act
        $result = $service->findLocale($originLocale);

        //assert
        $this->assertEquals($defaultLocale, $result);
    }
}
