<?php

namespace Backend\BaseBundle\Tests\Service;

use Backend\BaseBundle\Model\SiteConfig;
use Backend\BaseBundle\Service\LocaleObject;
use Backend\BaseBundle\Tests\Fixture\BaseKernelTestCase;

class LocaleObjectTest extends BaseKernelTestCase
{
    public function test_bindSiteConfig()
    {
        //arrange
        $service = new LocaleObject();
        $config = array(
            "default" => "this is default",
            "locales" => array("zoo", "yo-yo", "x-ray"),
            "enables" => array("zoo", "x-ray"),
        );

        //act
        $this->callObjectMethod($service, "bindSiteConfig", $config);

        //assert
        $this->assertEquals($config['default'], $service->getDefault());
        $this->assertEquals($config['locales'], $service->getLocales());
        $this->assertEquals($config['enables'], $service->getEnables());
    }
}
