<?php
namespace Backend\BaseBundle\Tests\Selenium;

use Backend\BaseBundle\Model\SiteUserQuery;
use Backend\BaseBundle\Tests\Fixture\BaseSelenium2TestCase;

class LoginTest extends BaseSelenium2TestCase
{
    /**
     * 在未登入的狀態下會導向登入頁
     */
    public function test_require_login()
    {
        //arrange
        $homePage = '/';

        //act
        $this->url($homePage);

        //assert
        $this->assertEquals("{$this->baseUrl}/#/login?path=".urlencode($homePage), $this->url());
    }

    /**
     * 執行登入
     */
    public function test_do_login()
    {
        //arrange
        $account = 'admin';
        $password = '12853714';
        $homeUrl = "{$this->baseUrl}/#/";
        $user = SiteUserQuery::create()->findOneByLoginName($account);
        $user->setPlainPassword($password);
        $this->container->get('site_user_manager')->updateUser($user);

        $this->url('/#/login');
        $input = $this->elements($this->using('css selector')->value('input'));

        //act
        $input[0]->value($account);
        $input[1]->value($password);
        $this->clickByCssSelector('button[type=submit]');

        //assert
        $this->waitUntilDisplayed('.fa.fa-sign-out', true, 30000);
        $this->assertEquals($homeUrl, $this->url());
        $this->assertTrue($this->byCssSelector('.left_col')->displayed());
    }

}

