<?php
namespace Backend\BaseBundle\Tests\Selenium;

use Backend\BaseBundle\Model\SiteUserQuery;
use Backend\BaseBundle\Tests\Fixture\BaseSelenium2TestCase;

class AlertTest extends BaseSelenium2TestCase
{
    /**
     * @dataProvider dataProvider_testAlert
     */
    public function testAlert($style, $class, $title, $titleUpperCase, $message)
    {
        // arrange
        $homePage = '/';

        // act
        $this->url($homePage);

        $this->execute(array(
            'script' => "rootComponent.\$store.dispatch('alert', {style: arguments[0], message: arguments[1], title: arguments[2]});",
            'args'   => array(
                $style,
                $message,
                $title,
            )
        ));

        // assert
        $this->waitUntilDisplayed(".ui-pnotify >.alert-$class");
        $this->assertEquals($titleUpperCase, $this->byCssSelector('.ui-pnotify h4.ui-pnotify-title')->text());
        $this->assertEquals($message, $this->byCssSelector('.ui-pnotify .ui-pnotify-text')->text());
    }

    public function dataProvider_testAlert()
    {
        return array(
            array(
                'style' => 'info',
                'class' => 'info',
                'title' => 'title info',
                'titleUpperCase' => 'Title Info',
                'message' => 'Info message',
            ),
            array(
                'style' => 'success',
                'class' => 'success',
                'title' => 'title success',
                'titleUpperCase' => 'Title Success',
                'message' => 'success message',
            ),
            array(
                'style' => 'warning',
                'class' => 'warning',
                'title' => 'title warning',
                'titleUpperCase' => 'Title Warning',
                'message' => 'warning message',
            ),
            array(
                'style' => 'error',
                'class' => 'danger',
                'title' => 'title error',
                'titleUpperCase' => 'Title Error',
                'message' => 'erroR message',
            ),
        );
    }
}