<?php
namespace Backend\BaseBundle\Tests\EventListener;

use Backend\BaseBundle\EventListener\I18nLocaleRequestListener;
use Backend\BaseBundle\Service\AdminLocaleSelector;
use Backend\BaseBundle\Service\LocaleAccessor;
use Backend\BaseBundle\Service\LocaleRequest\LocaleReadInterface;
use Backend\BaseBundle\Service\LocaleSelector;
use Backend\BaseBundle\Tests\Fixture\BaseKernelTestCase;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpKernel\Event\GetResponseEvent;

class I18nLocaleRequestListenerTest extends BaseKernelTestCase
{
    public function test_inject()
    {
        //arrange

        //act
        $listener = $this->container->get("backend.base_bundle.event_listener.i18n_locale_request_listener");

        //assert
        $this->assertInstanceOf(LocaleSelector::class, $this->getObjectAttribute($listener, 'localeSelector'));
        $this->assertInstanceOf(AdminLocaleSelector::class, $this->getObjectAttribute($listener, 'adminLocaleSelector'));
        $this->assertInstanceOf(LocaleReadInterface::class, $this->getObjectAttribute($listener, 'localeReader'));
    }
    
    public function test_onLocaleRequest_前台()
    {
        //arrange
        $listener = $this->getMockBuilder(I18nLocaleRequestListener::class)
            ->setMethods(array('isRequestFromAdmin'))
            ->getMock();

        $listener->expects($this->once())
            ->method("isRequestFromAdmin")
            ->willReturn(false);

        $locale = 'zh_TW';
        $defaultLocale = "zh_TW";
        $localeResult = "zh_CN";
        $request = new Request();
        $request->headers->set("X-Locale", array($locale));
        $event = $this->getMockBuilder(GetResponseEvent::class)
            ->disableOriginalConstructor()
            ->setMethods(array('getRequest'))
            ->getMock();
        $event
            ->expects($this->once())
            ->method('getRequest')
            ->willReturn($request);

        $service = $this->getMockBuilder(LocaleSelector::class)
            ->setMethods(array('findLocale'))
            ->getMock($request->headers->get("X-Locale"));

        $service->expects($this->once())
            ->method("findLocale")
            ->willReturnCallback(function ($arg0) use ($locale, $localeResult) {
                $this->assertEquals($locale, $arg0);
                return $localeResult;
            });

        $reader = $this->getMockBuilder(LocaleAccessor::class)
            ->setMethods(array("getDefault"))
            ->getMock();

        $reader->expects($this->once())
            ->method("getDefault")
            ->willReturn($defaultLocale);

        $this->setObjectAttribute($listener, "localeSelector", $service);
        $this->setObjectAttribute($listener, "localeReader", $reader);

        //act
        $listener->onLocaleRequest($event);

        //assert
        $this->assertEquals($localeResult, $request->attributes->get('_locale'));
        $this->assertEquals($defaultLocale, $request->attributes->get('_defaultLocale'));
    }

    public function test_onLocaleRequest_後台()
    {
        //arrange
        $listener = $this->getMockBuilder(I18nLocaleRequestListener::class)
            ->setMethods(array('isRequestFromAdmin'))
            ->getMock();

        $listener->expects($this->once())
            ->method("isRequestFromAdmin")
            ->willReturn(true);

        $locale = 'zh_TW';
        $defaultLocale = "zh_TW";
        $localeResult = "zh_CN";
        $request = new Request();
        $request->headers->set("X-Locale", array($locale));
        $event = $this->getMockBuilder(GetResponseEvent::class)
            ->disableOriginalConstructor()
            ->setMethods(array('getRequest'))
            ->getMock();
        $event
            ->expects($this->once())
            ->method('getRequest')
            ->willReturn($request);

        $service = $this->getMockBuilder(AdminLocaleSelector::class)
            ->setMethods(array('findLocale'))
            ->getMock($request->headers->get("X-Locale"));

        $service->expects($this->once())
            ->method("findLocale")
            ->willReturnCallback(function ($arg0) use ($locale, $localeResult) {
                $this->assertEquals($locale, $arg0);
                return $localeResult;
            });

        $reader = $this->getMockBuilder(LocaleAccessor::class)
            ->setMethods(array("getDefault"))
            ->getMock();

        $reader->expects($this->once())
            ->method("getDefault")
            ->willReturn($defaultLocale);

        $this->setObjectAttribute($listener, "adminLocaleSelector", $service);
        $this->setObjectAttribute($listener, "localeReader", $reader);

        //act
        $listener->onLocaleRequest($event);

        //assert
        $this->assertEquals($localeResult, $request->attributes->get('_locale'));
        $this->assertEquals($defaultLocale, $request->attributes->get('_defaultLocale'));
    }
}
