<?php
/**
 * Created by PhpStorm.
 * User: bubble
 * Date: 2018/1/10
 * Time: 上午11:32
 */

namespace Backend\BaseBundle\Tests\Controller\BackendAPI;

use Backend\BaseBundle\Event\NewLocaleEvent;
use Backend\BaseBundle\Model\SiteConfig;
use Backend\BaseBundle\Model\SiteConfigQuery;
use Backend\BaseBundle\Model\SiteUserQuery;
use Backend\BaseBundle\Service\LocaleObject;
use Backend\BaseBundle\Tests\Fixture\BackendWebTestCase;
use Symfony\Component\HttpFoundation\Response;

class LocaleConfigControllerTest extends BackendWebTestCase
{
    public function test_getLocaleNamesAction()
    {
        //arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $user = SiteUserQuery::create()->findOneByLoginName($loginName);
        $token = $this->createToken($user, $origin);

        //act
        $this->client->request(
            'GET',
            $this->generateUrl('backend_base_backendapi_localeconfig_getlocalenames'),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            )
        );
        $response = $this->client->getResponse();
        $result = json_decode($response->getContent(), true);

        //assert
        $this->assertTrue($response->isOk());
    }

    public function test_readAction()
    {
        //arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $user = SiteUserQuery::create()->findOneByLoginName($loginName);
        $token = $this->createToken($user, $origin);
        $configContent = array(
            'default' => 'zh_TW',
            'locales' => array('zh_TW', 'zh_CN'),
            'enables' => array('zh_TW')
        );

        $service = $this->getMockBuilder(LocaleObject::class)
            ->setMethods(array("getDefault", "getLocales", "getEnables"))
            ->getMock();

        $service->expects($this->atLeastOnce())
            ->method("getDefault")
            ->willReturn($configContent['default']);

        $service->expects($this->once())
            ->method("getLocales")
            ->willReturn($configContent['locales']);

        $service->expects($this->atLeastOnce())
            ->method("getEnables")
            ->willReturn($configContent['enables']);

        $this->client->getContainer()->set("locale_object", $service);

        //act
        $this->client->request(
            'GET',
            $this->generateUrl('backend_base_backendapi_localeconfig_read'),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            )
        );
        $response = $this->client->getResponse();
        $result = json_decode($response->getContent(), true);

        //assert
        $this->assertTrue($response->isOk());
        $this->assertArrayHasKey('default', $result);
        $this->assertEquals('zh_TW', $result['default']);
        $this->assertArrayHasKey('locales', $result);
        $this->assertEquals(array('zh_TW', 'zh_CN'), $result['locales']);
        $this->assertArrayHasKey('enables', $result);
        $this->assertEquals(array('zh_TW'), $result['enables']);
    }

    public function test_updateAction()
    {
        //arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $user = SiteUserQuery::create()->findOneByLoginName($loginName);
        $token = $this->createToken($user, $origin);
        $parameter = array(
            'default' => 'zh_TW',
            'locales' => array('zh_TW', 'zh_CN', 'en_US'),
            'enables' => array('zh_TW'),
            'titles' => array('zh_TW')
        );

        $service = $this->getMockBuilder(LocaleObject::class)
            ->setMethods(array("setDefault", "setLocales", "setEnables","setTitles", "save",
                "getDefault", "getLocales", "getEnables", "getTitles"))
            ->getMock();

        $service->expects($this->once())
            ->method("setDefault")
            ->with($parameter['default'])
            ->willReturn($service);
        $service->expects($this->once())
            ->method("setLocales")
            ->with($parameter['locales'])
            ->willReturn($service);
        $service->expects($this->once())
            ->method("setEnables")
            ->with($parameter['enables'])
            ->willReturn($service);
        $service->expects($this->once())
            ->method("setTitles")
            ->with($parameter['titles'])
            ->willReturn($service);
        $service->expects($this->once())
            ->method("save")
            ->with();

        $service->expects($this->atLeastOnce())
            ->method("getDefault")
            ->willReturn($parameter['default']);
        $service->expects($this->once())
            ->method("getLocales")
            ->willReturn($parameter['locales']);
        $service->expects($this->atLeastOnce())
            ->method("getEnables")
            ->willReturn($parameter['enables']);
        $service->expects($this->atLeastOnce())
            ->method("getTitles")
            ->willReturn($parameter['titles']);

        $this->client->getContainer()->set("locale_object", $service);
        $eventDispatcher = $this->client->getContainer()->get('event_dispatcher');
        $eventDispatcher->addListener(NewLocaleEvent::EVENT_NAME, function(NewLocaleEvent $event) use($parameter){
            $this->assertEquals($parameter['locales'], $event->getLocales());
        }, 99999);
        //act
        $this->client->request(
            'PUT',
            $this->generateUrl('backend_base_backendapi_localeconfig_update'),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            ),
            json_encode($parameter)
        );
        $response = $this->client->getResponse();
        $result = json_decode($response->getContent(), true);

        //assert
        $this->assertTrue($response->isOk());
        $this->assertArrayHasKey('default', $result);
        $this->assertEquals($parameter['default'], $result['default']);
        $this->assertArrayHasKey('locales', $result);
        $this->assertEquals($parameter['locales'], $result['locales']);
        $this->assertArrayHasKey('enables', $result);
        $this->assertEquals($parameter['enables'], $result['enables']);
    }

    public function test_updateAction_參數設歪()
    {
        //arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $user = SiteUserQuery::create()->findOneByLoginName($loginName);
        $token = $this->createToken($user, $origin);
        $parameter = array(
            'defffault' => 'zh_TW',
            'locales' => array('zh_TW', 'zh_CN', 'en_US'),
            'enables' => array('zh_TW')
        );

        $service = $this->getMockBuilder(LocaleObject::class)
            ->setMethods(array("setDefault", "setLocales", "setEnables", "save"))
            ->getMock();

        $service->expects($this->never())
            ->method("setDefault")
            ;

        $service->expects($this->never())
            ->method("setLocales")
            ;

        $service->expects($this->never())
            ->method("setEnables")
            ;

        $service->expects($this->never())
            ->method("save")
            ;

        $this->client->getContainer()->set("locale_object", $service);

        //act
        $this->client->request(
            'PUT',
            $this->generateUrl('backend_base_backendapi_localeconfig_update'),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            ),
            json_encode($parameter)
        );
        $response = $this->client->getResponse();

        //assert
        $this->assertEquals(Response::HTTP_BAD_REQUEST, $response->getStatusCode());
    }

    public function test_updateAction_參數設歪2()
    {
        //arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $user = SiteUserQuery::create()->findOneByLoginName($loginName);
        $token = $this->createToken($user, $origin);
        $parameter = array(
            'default' => 'zh_TW',
            'locales' => "abc",
            'enables' => array('zh_TW')
        );

        $service = $this->getMockBuilder(LocaleObject::class)
            ->setMethods(array("setDefault", "setLocales", "setEnables", "save"))
            ->getMock();

        $service->expects($this->never())
            ->method("setDefault")
        ;

        $service->expects($this->never())
            ->method("setLocales")
        ;

        $service->expects($this->never())
            ->method("setEnables")
        ;

        $service->expects($this->never())
            ->method("save")
        ;

        $this->client->getContainer()->set("locale_object", $service);

        //act
        $this->client->request(
            'PUT',
            $this->generateUrl('backend_base_backendapi_localeconfig_update'),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            ),
            json_encode($parameter)
        );
        $response = $this->client->getResponse();

        //assert
        $this->assertEquals(Response::HTTP_BAD_REQUEST, $response->getStatusCode());
    }
}
