<?php
namespace Backend\BaseBundle\Tests\Controller\API;

use Backend\BaseBundle\Model\SiteConfigQuery;
use Backend\BaseBundle\Model\SiteQuery;
use Backend\BaseBundle\Tests\Fixture\BackendWebTestCase;
use Symfony\Component\HttpFoundation\Response;

class SEOControllerTest extends BackendWebTestCase
{
    private $originConfigs;

    public function test_indexAction_bad_request()
    {
        //arrange

        //act
        $this->client->request(
            'GET',
            $this->generateUrl('backend_base_api_seo_index')
        );
        $response = $this->client->getResponse();

        //assert
        $this->assertEquals(Response::HTTP_BAD_REQUEST, $response->getStatusCode());
    }

    public function test_indexAction_parse_url_fail_bad_url()
    {
        //arrange
        $url = 'http:aksksajhkjsa';

        //act
        $this->client->request(
            'GET',
            $this->generateUrl('backend_base_api_seo_index', array('url' => $url))
        );
        $response = $this->client->getResponse();

        //assert
        $this->assertEquals(Response::HTTP_NOT_ACCEPTABLE, $response->getStatusCode());
    }

    public function test_indexAction_parse_url_fail_bad_sheme()
    {
        //arrange
        $url = 'abc://aksksajhkjsa/';

        //act
        $this->client->request(
            'GET',
            $this->generateUrl('backend_base_api_seo_index', array('url' => $url))
        );
        $response = $this->client->getResponse();

        //assert
        $this->assertEquals(Response::HTTP_NOT_ACCEPTABLE, $response->getStatusCode());
    }

    public function test_indexAction_bad_domains()
    {
        //arrange
        $url = 'http://badsite.com/';

        //act
        $this->client->request(
            'GET',
            $this->generateUrl('backend_base_api_seo_index', array('url' => $url))
        );
        $response = $this->client->getResponse();

        //assert
        $this->assertEquals(Response::HTTP_FORBIDDEN, $response->getStatusCode());
    }

    public function test_indexAction_ok()
    {
        //arrange
        $serverSideRender = $this->getMockBuilder(ServerSideRender::class)
            ->disableOriginalConstructor()
            ->setMethods(array('render'))
            ->getMock();
        $serverSideRender
            ->expects($this->once())
            ->method('render')
            ->willReturn(json_encode(array(
                'status' => true,
                'content' => 'test content'
            )));
        $this->client->getContainer()->set('server_side_render', $serverSideRender);
        $url = 'http://www.example.com/';

        //act
        $this->client->request(
            'GET',
            $this->generateUrl('backend_base_api_seo_index', array('url' => $url))
        );
        $response = $this->client->getResponse();
        $result = json_decode($response->getContent(), true);

        //assert
        $this->assertTrue($response->isOk(), $response->getStatusCode());
        $this->assertTrue($result['status']);
        $this->assertTrue(strpos($result['content'], 'test content') !== false);
    }

    public function setUp()
    {
        parent::setUp(); // TODO: Change the autogenerated stub
        $siteConfig = SiteConfigQuery::create()->findPk('system');
        $this->originConfigs = $siteConfig->getConfig();
    }

    protected function tearDown()
    {
        $siteConfig = SiteConfigQuery::create()->findPk('system');
        $siteConfig->setConfig($this->originConfigs);
        $siteConfig->save();
        parent::tearDown(); // TODO: Change the autogenerated stub
    }
}