<?php

namespace Backend\BaseBundle\Service;

use Backend\BaseBundle\Service\LocaleRequest\LocaleReadInterface;
use Backend\BaseBundle\Service\LocaleRequest\LocaleSelectorInterface;
use JMS\DiExtraBundle\Annotation as DI;

/**
 * @DI\Service("locale_selector")
 */
class LocaleSelector implements LocaleSelectorInterface
{
    /** @var LocaleReadInterface */
    protected $localeRead;

    /**
     * @DI\InjectParams({
     *      "localeRead" = @DI\Inject("locale_object")
     * })
     */
    public function injectLocaleReadInterface(LocaleReadInterface $localeRead)
    {
        $this->localeRead = $localeRead;
    }

    /**
     * @param string $originLocale 原始的語系
     * @return string|null resultLocale 計算後的結果語系
     */
    public function findLocale(string $originLocale = null)
    {
        if (is_null($originLocale)) {
            return $this->localeRead->getDefault();
        }

        if (is_null($enables = $this->localeRead->getEnables())) {
            return $this->localeRead->getDefault();
        }

        if (!in_array($originLocale, $enables)) {
            return $this->localeRead->getDefault();
        }

        return $originLocale;
    }
}
