<?php
/**
 * Created by PhpStorm.
 * User: bubble
 * Date: 2018/1/10
 * Time: 下午12:34
 */
namespace Backend\BaseBundle\Service;

use Backend\BaseBundle\Model\SiteConfigQuery;
use Backend\BaseBundle\Service\LocaleRequest\LocaleReadInterface;
use Backend\BaseBundle\Service\LocaleRequest\LocaleWriteInterface;
use JMS\DiExtraBundle\Annotation as DI;

/**
 * @DI\Service("locale_object")
 */
class LocaleObject implements LocaleReadInterface, LocaleWriteInterface
{
    protected $siteConfig;
    protected $default_string;
    protected $locales_array;
    protected $enables_array;
    protected $titles_array;

    public function __construct()
    {
        $this->siteConfig = SiteConfigQuery::create()->filterByName('locale')->findOneOrCreate();
        $this->bindSiteConfig($this->siteConfig->getConfig());
    }

    protected function bindSiteConfig($config)
    {
        if (is_null($config)) {
            return;
        }

        foreach($config as $key => $value){
            $method = str_replace('_', '', 'set'.ucwords("{$key}", '_'));
            if(is_callable(array($this, $method))) {
                call_user_func(array($this, $method), $value);
            }
        }
    }

    /** @return string */
    public function getDefault()
    {
        return $this->default_string;
    }

    /** @return array */
    public function getLocales()
    {
        return $this->locales_array;
    }

    /** @return array */
    public function getEnables()
    {
        return $this->enables_array;
    }

    /** @return array */
    public function getTitles()
    {
        return $this->titles_array;
    }

    public function setDefault(string $default)
    {
        $this->default_string = $default;
        return $this;
    }

    public function setLocales(array $locales)
    {
        $this->locales_array = $locales;
        return $this;
    }

    public function setEnables(array $enables)
    {
        $this->enables_array = $enables;
        return $this;
    }

    public function setTitles(array $titles)
    {
        $this->titles_array = $titles;
        return $this;
    }

    public function save()
    {
        $this->siteConfig
            ->setName('locale')
            ->setConfig($this->processConfig())
            ->save();
        return $this->bindSiteConfig($this->siteConfig->getConfig());
    }

    /**
     * @return array
     */
    protected function processConfig(): array
    {
        return array(
            'default' => $this->default_string,
            'locales' => $this->locales_array,
            'enables' => $this->enables_array,
            'titles' => $this->titles_array
        );
    }
}