<?php
namespace Backend\BaseBundle\Service;


use JMS\DiExtraBundle\Annotation as DI;
use JMS\DiExtraBundle\Annotation\Inject;
use JMS\DiExtraBundle\Annotation\InjectParams;
use JMS\DiExtraBundle\Annotation\Service;
use JMS\DiExtraBundle\Annotation\Tag;
use JMS\Serializer\Context;
use JMS\Serializer\JsonSerializationVisitor;
use JMS\Serializer\VisitorInterface;
use Symfony\Bundle\FrameworkBundle\Templating\Helper\AssetsHelper;
use Symfony\Component\Form\FormError;
use Symfony\Component\Form\FormErrorIterator;
use Widget\PhotoBundle\Image\Resolver;
use Widget\PhotoBundle\Model\Photo;

/**
 * @Service()
 * @Tag("jms_serializer.handler", attributes = {"public": false, "type": FormErrorIterator::class, "format": "json", "method": "onFormErrorIterator"})
 */
class FormErrorSerializerHandler
{
    public function onFormErrorIterator(VisitorInterface $visitor, FormErrorIterator $errors, array $type, Context $context)
    {
        return $visitor->visitArray($this->serializeFormErrorIterator($errors), $type, $context);
    }

    protected function serializeFormErrorIterator(FormErrorIterator $errors)
    {
        $message = array();
        foreach ($errors as $error){
            if($error instanceof FormError){
                $message[$error->getOrigin()->getName()] = $error->getMessage();
            }
            else{
                $message[$error->getOrigin()->getName()] = $error;
            }
        }
        return $message;
    }
}