# 樹狀結構管理元件

## 基本使用方式

**設定樣板載入tree mixins以及設定檔**
```html
<template>
  <div class="page-content">
    <TreeComponent/>
  </div>
</template>

<script lang="babel!coffee" type="text/coffeescript">
module.exports =
  mixins: [
    require('components/backendbase/mixins/tree.coffee'),
  ]
  computed:
    config: () -> require 'components/widgetcategoryarticle/router/tree/categoryarticle.coffee'
</script>
```
**設定檔**
```coffeescript
module.exports =
  # 樹的名稱
  thread: 'carticle'
```

## 設定檔可用選項

### 預設新節點名稱

> String

新點名稱預設為**新分類**

如需指定可使用**default_node_name**來指定

```coffeescript
default_node_name: 'tree.default_node_name'
```

### 載入自訂元件

> Array

如果需要載入自訂元件

可使用**components**參數設定一個array載入自訂元件

```coffeescript
components: [
  require '/path/to/component-A.vue'
  require '/path/to/component-B.vue'
]
```

自訂元件將會得到以下幾個props參數

* item(Object): 點擊的節點實體
* formNode(Object): 表單的節點資料(更新模式時將會等於item)
* formMode(String): 表單模式, 分為新增模式(create)以及更新模式(update)

### 深度限制

> Integer

可使用 **limit** 選項來設定


## 事件

### 表單重新讀取事件

此事件將會在使用者點選節點/切換語系時被觸發

可由data參數取得read後的資料

```coffeescript
module.exports = 
  created: () ->
    @$root.$on 'tree.form.read.node', data
  beforeDestroy: () ->
    @$root.$off 'tree.form.read.node'
```

### 表單新增成功事件

此事件將會在表單新增成功時被觸發

可由data參數取得新增後的節點實體資料

```coffeescript
module.exports = 
  created: () ->
    @$root.$on 'tree.form.create.success', data
  beforeDestroy: () ->
    @$root.$off 'tree.form.create.success'
```

### 表單更新成功事件

此事件將會在表單更新成功時被觸發

可由data參數取得更新後的節點實體資料

```coffeescript
module.exports = 
  created: () ->
    @$root.$on 'tree.form.update.success', data
  beforeDestroy: () ->
    @$root.$off 'tree.form.update.success'
```

### 表單刪除成功事件

此事件將會在表單刪除成功時被觸發

可由data參數取得刪除後的節點實體資料

```coffeescript
module.exports = 
  created: () ->
    @$root.$on 'tree.form.delete.success', data
  beforeDestroy: () ->
    @$root.$off 'tree.form.delete.success'
```