# 列表設定檔

## Gist
[Gist](https://gist.github.com/ciao-dgfactor/e31c47d4c72f50d877e9b3a075d26789)

## 列表基本說明

```coffeescript
id:
  label: "index.order.id",
  type: "text",
```

**列表欄位可用型態**

* text: 一般文字欄位
* image: 圖片
* hidden: 隱藏欄位(希望出現在搜尋列中, 但不希望顯示)
* date: 日期(YYYY-MM-DD)
* datetime-local: 時間(YYYY-MM-DD HH:mm:SS)
* checkbox: switch元件

**關聯**

不論任何型態

如果要使用關聯property key可使用'.'

參考CM4訂單列表設定(components/widgetorder/config/list/order.coffee)

```coffeescript
'order_info.buyer_name':
  label: 'index.order.info.buyer_name'
```

**前綴**

如果希望將資料加上前綴

可使用**config.label_prefix**

```coffeescript
'payment.payment_status':
  'config':
    label_prefix: 'index_value.payment.payment_status'
```

## 列表欄位各型態說明

### text

> 文字欄位

參考CM4帳號列表設定(components/backendbase/config/list/siteuser.coffee)

```coffeescript
email:
  label: 'index.site_user.email'
```

### image

> 圖片

參考CM4產品列表設定(components/widgetproduct/config/list/product.coffee)

```coffeescript
photos: {
  label: 'index.product.photos'
  type: image
``` 

### hidden

> 隱藏欄位

可能需要用到該欄位來搜尋

但不想顯示在列表上

參考公視影音列表設定(components/widgetvideo/config/video/list.coffee)

```coffeescript
youtube_link:
  label: 'index.video.video_type'
  type: 'hidden'
```

### date

> 日期(YYYY-MM-DD)

參考公視coupon列表設定(components/widgetcoupon/config/code/list.coffee)

```coffeescript
expired_at:
  label: 'index.code.expired_at'
  type: 'date'
```

### datetime-local

> 時間(YYYY-MM-DD HH:mm:SS)

參考CM4帳號列表設定(components/backendbase/config/list/siteuser.coffee)

```coffeescript
created_at:
  label: 'index.site_user.created_at'
  type: 'datetime-local'
```

### checkbox

> switch元件

參考CM4帳號列表設定(components/backendbase/config/list/siteuser.coffee)

預設為boolean, 開啟為true, 關閉為false

```coffeescript
enabled: {
  label: 'index.site_user.enabled'
  type: 'checkbox'
```

如果希望自訂開啟/關閉的值

可使用config.value選項設定

```coffeescript
enabled: {
  label: 'index.site_user.enabled'
    type: 'checkbox'
  config:
    value:
      true: 1
      false: 0
```

## 排序

不論任何型態

加上sort選項可允許排序

```coffeescript
email: {
  label: 'index.site_user.email'
  type: 'text'
  sort: true
```

如果希望為該頁的預設排序

可使用**defaultSorting**並設定排序方式

**但sort一樣要設定為true**

```coffeescript
created_at: {
  label: 'index.site_user.created_at'
  type: 'datetime-local'
  sort: true
  defaultSorting: 'desc'
```

## 搜尋

首先要設定為搜尋

要先將**search**設定為true(一定要設, 沒辦法當時資料結構設計太爛, 現在知道也不敢隨便改, 太多專案用怕改爛)

接者以**searchConfig.type**來設定搜尋欄位的型態

### 搜尋-文字欄位(text)

* key: 設定要搜尋的欄位
* like: 送出前會自動加'%'來做模糊搜尋, 例如'%dg%'

參考CM4帳號列表設定(components/backendbase/config/list/siteuser.coffee)

```coffeescript
login_name: {
  search: true
  searchConfig:
    key: 'login_name'
    like: true
    type: 'text'
```

### 搜尋-多選一欄位(select)

參考CM4訂單列表設定(components/widgetorder/config/list/order.coffee)

* key: 設定要搜尋的欄位
* api: 下拉選單項目的api來源, 必須return一個promise
* choiceValue: 選單選項的值 property name
* choiceLabel: 選單選項的顯示 property name

```coffeescript
'order_status.name':
  search: true
  searchConfig:
    key: 'order_status_id'
    type: 'select'
    api: 'order.orderStatus'
    choiceValue: 'id'
    choiceLabel: 'name'
```

### 搜尋-二選一欄位(radio)

參考CM4產品列表設定(components/widgetproduct/config/list/product.coffee)

* key: 設定要搜尋的欄位
* label: 設定true/false的顯示文字

```coffeescript
status_shelf:
  search: true
  searchConfig:
    key: 'status_shelf'
    type: 'radio'
    label:
      true: 'index.product.search.status_shelf.true'
      false: 'index.product.search.status_shelf.false'
```

如果不希望選項的值為boolean

可使用**searchConfig.value**選項自訂true/false的值

參考公視影音列表設定(components/widgetvideo/config/video/list.coffee)

```coffeescript
youtube_link:
  search: true
  searchConfig:
    key: "youtube_link"
    type: "radio"
    label:
      true: 'index.video.is_youtube.true'
      false: 'index.video.is_youtube.false'
    value:
      true: '%http%'
      false: 'null'
```

## 批次操作

首先要先將batch設定為true

並使用batchSetting來設定

batchSetting內的label為批次動作顯示的文字

value為該欄位要賦予的值

參考CM4帳號列表設定(components/backendbase/config/list/siteuser.coffee)

```coffeescript
"enabled": {
  batch: true
  batchSetting: [
    { label: 'index.site_user.enable', value: true }
    { label: 'index.site_user.disable', value: false }
  ]
```

## 自訂批次操作

直接在列表設定檔中

設定**customBatch**並給予一個array

每個array element中使用**component**載入vue元件

如果需要特別設定權限可使用**roles**

參考ukik課程列表設定(components/widgetcourse/config/list/course.coffee)

```coffeescript
customBatch: [
  {
    roles: ['ROLE_COUPON_WRITE']
    component: require 'components/widgetcourse/customize/list/actions/homepromote_add_course.vue'
  }
  {
    roles: ['ROLE_COUPON_WRITE']
    component: require 'components/widgetcourse/customize/list/actions/homepromote_remove_course.vue'
  }
]
```

## 動作

直接在列表設定中使用**action**並給予一個array

共同設定
* roles: 限制該動作按鈕權限

### 編輯

導向該列表的表單

* name: 要設定為edit
* route: 表單的vue route name
* label: 顯示的文字

```coffeescript
action: [
  {
    name: 'edit'
    label: 'action.edit'
    roles: ['ROLE_SUPERADMIN']
    route: 'siteuser-edit'
  }
]
```

### 自訂動作元件

使用component載入自訂元件

```coffeescript
action: [
  {
    roles: ['ROLE_COURSE_READ']
    component: require('components/widgetcourse/customize/list/actions/schedule.vue')
  }
]
```