# 表單設定檔

## Gist

[Gist](https://gist.github.com/ciao-dgfactor/25006e44e1d6053d9f7c06850f327edc)

## 表單基本說明

* name: 欄位名稱
* text: 顯示文字
* type: 欄位型態
* required(optional): 顯示必填圖示(*) 

```coffeescript
{
  name: 'name'
  text: 'index.product.name'
  required: true
  type: 'input'
}
```

如果需要加上help

可使用**config.help**

```coffeescript
config:
  help: 'form.help.feature.name'
```

## 表單欄位各型態說明

### input

> 文字欄位

```coffeescript
{
  name: 'name'
  text: 'index.product.name'
  type: 'input'
}
```

### textarea

> textareax欄位

```coffeescript
{
  name: 'brief'
  text: 'index.product.brief'
  type: 'textarea'
}
```

### selector

> 多選下拉選單

* config.api: 下拉選單的資料來源api
* config.removeRoot(optional): 移除第一個選項, 取分類時會需要用到

參考CM4商品表單(components/widgetproduct/config/edit/product.coffee)
 
```coffeescript
{
  name: 'categories'
  text: 'index.product.groups'
  type: 'selector'
  config:
      api: 'product.getCategories'
      removeRoot: true
}
```

### html

> html文字編輯器

```coffeescript
{
  name: 'content'
  text: 'index.product.content'
  type: 'html'
}
```

### date

> 日期

```coffeescript
{
  name: 'start_at'
  text: 'form.label.edit.banner.start_at'
  type: 'date'
}
```

新增時預設日期為當下的日期

如果希望自訂預設日期

可使用**default**設定

* default.type: 預設日期型態, 分為increment(增加), decrement(減少)
* unit: 增加或減少的單位, 可使用'year', 'day'
* value: 增加或減少的值

參考CM4 banner表單設定(components/widgetbanner/config/edit/banner.coffee)

```coffeescript
{
  name: 'start_at'
  text: 'form.label.edit.banner.start_at'
  type: 'date'
  default:
    type: 'increment'
    unit: 'year'
    value: 100
}
```

### datetime

> 時間

```coffeescript
{
  name: 'release_at'
  text: 'index.program.release_at'
  type: 'datetime'
}
```

### number

> 數字欄位

```coffeescript
{
  name: 'foo'
  type: 'number'
}
```

### photos

> 圖片

* config.max: 多最張數
* config.min: 多少張數
* config.configType: 上傳的類型, 預設使用default
```coffeescript
{
  name: "photos",
  text: "form.label.edit.banner.photos",
  type: "photos",
  config:
    max: 1
    min: 1
    configType: 'banner'
}
```

### switch

> switch元件

* config.on: 開啟時顯示的文字
* config.off: 關閉時顯示的文字

```coffeescript
{
  name: 'status'
  text: 'form.label.edit.banner.status'
  type: 'switch'
  config:
    on: 'form.choice.enable'
    off: 'form.choice.disable'
}
```

### choice

> 多選一

* config.api: 下拉選單資料來源
* config.value: 選項的value property name
* config.label: 選項的value property label

參考CM4 banner表單設定(components/widgetbanner/config/edit/banner.coffee)
 
```coffeescript
{
  name: 'banner_id'
  text: 'form.label.edit.banner.banner'
  type: 'choice'
  config:
    api: 'banner.bannerCategory'
    value: 'id'
    label: 'title'
}
```
 
## i18n

> 多語系設定

只要將表單type設定為i18n

該表單將會自動處理切換重新read

送出表單request header也會帶入切換的locale

參考CM4_i18n的文章表單設定(components/widgetarticle/config/edit/article.coffee)

```coffeescript
{
  type: 'i18n'
}
``` 

如果希望有語系狀態

則加入data_status選項

```coffeescript
{
  type: 'i18n'
  data_status: true
}
``` 

## 自訂表單元件

type設定為customize

並在component載入自訂元件

```coffeescript
{
  type: 'customize'
  component: require 'components/widgetproduct/customize/edit/stock.vue'
}
```

## 儲存後發其他關聯的api
