import Vue from 'vue'
import VueHead from 'vue-head'
import VueRouter from 'vue-router'
import VueMoment from 'vue-moment'
import cm4RouterConfig from './cm4/routers.coffee'
import routerConfig from '../cm4/routers.coffee'
import lang from './libs/lang.coffee'
import './libs/translation.coffee'
import langs from 'components/backendbase/langs.json'
import store from './store/store.coffee'
import app from './app.vue'
import dispatcher from './libs/dispatcher.coffee'
import meta from "assets/backendbase/meta/default.json"
import vue2Filter from 'vue2-filters'
isDebugMode = process.env.NODE_ENV != 'production'
Vue.config.debug = isDebugMode
Vue.config.devtools = isDebugMode

Vue.use VueHead
Vue.use VueRouter
Vue.use VueMoment
Vue.use vue2Filter
Vue.filter 'lang', (locale) -> langs[locale]
router = new VueRouter
  hashbang: true
  mode: 'hash'
  routes: cm4RouterConfig.concat routerConfig

window.rootComponent = new Vue
  el:    "app"
  store: store
  computed:
    api: () -> @$store.getters.api
    token: () -> @$store.getters.token
    locale_config: () -> @$store.getters.locale
  watch:
    locale_config:
      deep: true
      handler: () ->
        return if !@locale_config
        @$root.$emit 'locale.ready'
  mounted: () ->
    me = @
    window.trans = @$options.filters.trans
    @$store.dispatch 'public.trans', @$options.filters.trans
    @$root.$on 'login.success', @initLocale

    # 單純為了等另開分頁的session ready, 不等的話另開會有問題
    setTimeout () ->
      me.initLocale()
      me.handleToken()
    , 100
  methods:
    initLocale: () ->
      me = @
      if !@token.getToken()
        @$root.$emit 'locale.ready'
        return
      _api = @api.getLocales()
      _api.then (result) -> me.$store.dispatch 'locale.init', result
      _api.catch () -> me.$root.$emit 'locale.ready'
    handleToken: () ->
      me = @
      @token.renewToken = () ->
        me.api.renewToken()
        .then (data) ->
          me.$store.dispatch "token.setToken", data.token
        .catch () ->
          me.$store.dispatch "token.clearToken"
          return
      if @token.getToken() == null && @$route.meta['require-login'] != false
        @$router.push
          name: 'login'
          query:
            path: @$route.path
  data: () ->
    _: require('lodash')
    {
      dispatcher: dispatcher @
      lang: lang
      head: meta
    }
  router: router
  render: (h) ->
    h app
  head:
    title: () ->
      {
        inner:  @head.title
        separator: ' '
        complement: ' '
      }
    meta: () ->
      @head.meta