<?php
namespace Backend\BaseBundle\Propel\Behavior;

use PropelTypes;

class I18nBehavior extends \I18nBehavior
{
    protected function getDirname()
    {
        if (null === $this->dirname) {
            $r = new \ReflectionClass(parent::class);
            $this->dirname = dirname($r->getFileName());
        }
        return $this->dirname;
    }

    protected function addLocaleColumnToI18n()
    {
        $localeColumnName = $this->getLocaleColumnName();
        if (!$this->i18nTable->hasColumn($localeColumnName)) {
            $this->i18nTable->addColumn(array(
                'name'       => $localeColumnName,
                'type'       => PropelTypes::VARCHAR,
                'size'       => 32,
                'default'    => $this->getDefaultLocale(),
                'primaryKey' => 'true',
            ));
        }
    }

    public function getObjectBuilderModifier()
    {
        if (is_null($this->objectBuilderModifier)) {
            $this->objectBuilderModifier = new I18nBehaviorObjectBuilderModifier($this);
        }

        return $this->objectBuilderModifier;
    }

    public function getQueryBuilderModifier()
    {
        if (is_null($this->queryBuilderModifier)) {
            $this->queryBuilderModifier = new I18nBehaviorQueryBuilderModifier($this);
        }

        return $this->queryBuilderModifier;
    }

}