<?php
namespace Backend\BaseBundle\EventListener;

use Backend\BaseBundle\Service\AdminLocaleSelector;
use Backend\BaseBundle\Service\LocaleRequest\LocaleReadInterface;
use Backend\BaseBundle\Service\LocaleSelector;
use JMS\DiExtraBundle\Annotation as DI;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpKernel\Event\GetResponseEvent;

/**
 * @DI\Service()
 */
class I18nLocaleRequestListener
{
    /** @var LocaleSelector */
    protected $localeSelector;

    /** @var AdminLocaleSelector */
    protected $adminLocaleSelector;

    /** @var LocaleReadInterface */
    protected $localeReader;

    /**
     * @DI\InjectParams({
     *      "localeSelector" = @DI\Inject("locale_selector")
     * })
     */
    public function injectLocaleSelector(LocaleSelector $localeSelector)
    {
        $this->localeSelector = $localeSelector;
    }

    /**
     * @DI\InjectParams({
     *      "localeSelector" = @DI\Inject("admin_locale_selector")
     * })
     */
    public function injectAdminLocaleSelector(AdminLocaleSelector $localeSelector)
    {
        $this->adminLocaleSelector = $localeSelector;
    }

    /**
     * @DI\InjectParams({
     *      "localeReader" = @DI\Inject("locale_object")
     * })
     */
    public function injectLocaleReader(LocaleReadInterface $localeReader)
    {
        $this->localeReader = $localeReader;
    }

    /**
     * @DI\Observe("kernel.request")
     */
    public function onLocaleRequest(GetResponseEvent $event)
    {
        $request = $event->getRequest();
        $origin = $request->headers->get('X-Locale');

        $result = $this->isRequestFromAdmin($request) ?
            $this->adminLocaleSelector->findLocale($origin) :
            $this->localeSelector->findLocale($origin);
        $request->attributes->set('_locale', $result);

        $request->attributes->set('_defaultLocale', $this->localeReader->getDefault());
    }

    /**
     * @param Request $request
     * @return bool
     */
    protected function isRequestFromAdmin(Request $request)
    {
        return substr($request->getRequestUri(), 0, 6) == '/admin';
    }
}
