<?php
namespace Backend\BaseBundle\Event;


use Symfony\Component\EventDispatcher\Event;
use Symfony\Component\Translation\MessageCatalogueInterface;

class DumpTranslationEvent extends Event
{
    const EVENT_NAME = 'event.translation.dump';

    /** @var MessageCatalogueInterface  */
    protected $catalogue;
    protected $targetPath;

    public function __construct(MessageCatalogueInterface $catalogue, $targetPath)
    {
        $this->catalogue = $catalogue;
        $this->targetPath = $targetPath;
    }

    /**
     * @return MessageCatalogueInterface
     */
    public function getCatalogue()
    {
        return $this->catalogue;
    }

    /**
     * @return string
     */
    public function getTargetPath()
    {
        return $this->targetPath;
    }

}