<?php
/**
 * Created by PhpStorm.
 * User: bubble
 * Date: 2018/1/10
 * Time: 下午4:14
 */

namespace Backend\BaseBundle\Controller\BackendAPI;

use Backend\BaseBundle\Event\NewLocaleEvent;
use Backend\BaseBundle\Form\Type\APIFormTypeItem;
use Backend\BaseBundle\Service\LocaleObject;
use JMS\DiExtraBundle\Annotation as DI;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Symfony\Component\EventDispatcher\EventDispatcherInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Intl\Intl;
use Symfony\Component\Validator\Constraints\NotBlank;

/**
 * @Route("/locale")
 */
class LocaleConfigController extends BaseBackendAPIController
{
    /**
     * @var LocaleObject
     * @DI\Inject("locale_object")
     */
    protected $localeObject;

    protected function getFormConfig()
    {
        return array(
            (new APIFormTypeItem('default'))->setOptions(array(
                'constraints' => array(
                    new NotBlank(array(
                        'message' => 'error.missing_field',
                    )),
                )
            )),
            (new APIFormTypeItem('locales'))->setOptions(array(
                'constraints' => array(
                    new NotBlank(array(
                        'message' => 'error.missing_field',
                    )),
                )
            )),
            (new APIFormTypeItem('enables'))->setOptions(array(
                'constraints' => array(
                    new NotBlank(array(
                        'message' => 'error.missing_field',
                    )),
                )
            )),
            (new APIFormTypeItem('titles'))->setOptions(array(
                'constraints' => array(
                    new NotBlank(array(
                        'message' => 'error.missing_field',
                    )),
                )
            ))
        );
    }

    /**
     * 語系的下拉選單表單一大包（PM說不要原本的靜態json）
     * @Route("/names")
     * @Method({"GET"})
     * @Security("has_role_or_superadmin('ROLE_SETUP')")
     */
    public function getLocaleNamesAction()
    {
        $locale = $this->getParameter('locale');
        $intl = Intl::getLocaleBundle()->getLocaleNames($locale);
        return $this->createJsonResponse($intl);
    }

    /**
     * 讀取
     * @Route("")
     * @Method({"GET"})
     */
    public function readAction()
    {
        return $this->createJsonSerializeResponse($this->localeObject, array('list'));
    }

    /**
     * 更新
     * @Route("")
     * @Method({"PUT"})
     * @Security("has_role_or_superadmin('ROLE_SETUP')")
     */
    public function updateAction(Request $request)
    {
        $parameter = json_decode($request->getContent(), true);

        if (!$this->canUpdate($parameter)){
            return $this->createHttpExceptionResponse(Response::HTTP_BAD_REQUEST);
        }

        $this->localeObject
            ->setDefault($parameter['default'])
            ->setLocales($parameter['locales'])
            ->setEnables($parameter['enables'])
            ->setTitles($parameter['titles'])
            ->save();

        $this->extraProcess($parameter);

        return $this->createJsonSerializeResponse($this->localeObject, array('list'));
    }

    /**
     * @param $parameter
     */
    protected function extraProcess($parameter)
    {
        /** @var EventDispatcherInterface $eventDispatcher */
        $eventDispatcher = $this->get('event_dispatcher');
        $event = new NewLocaleEvent($parameter['locales']);
        $eventDispatcher->dispatch(NewLocaleEvent::EVENT_NAME, $event);
    }

    /**
     * @param $parameter
     * @return bool
     */
    protected function canUpdate($parameter)
    {
        if (!is_string($parameter['default'] ?? null)) {
            return false;
        }

        if (!is_array($parameter['locales'] ?? null)) {
            return false;
        }

        if (!is_array($parameter['enables'] ?? null)) {
            return false;
        }

        if (!is_array($parameter['titles'] ?? null)) {
            return false;
        }
        return true;
    }
}